/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.collection;

import java.util.Iterator;
import org.seasar.util.exception.SNoSuchElementException;
import org.seasar.util.exception.SUnsupportedOperationException;
import org.seasar.util.misc.AssertionUtil;

public class ArrayIterator<T>
implements Iterator<T> {
    protected final T[] items;
    protected int index = 0;

    public static <T> Iterable<T> iterable(final T ... items) {
        AssertionUtil.assertArgumentNotNull("items", items);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new ArrayIterator<Object>(items);
            }
        };
    }

    public ArrayIterator(T ... items) {
        this.items = items;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.items.length;
    }

    @Override
    public T next() {
        try {
            T o = this.items[this.index];
            ++this.index;
            return o;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SNoSuchElementException("index=" + this.index);
        }
    }

    @Override
    public void remove() {
        throw new SUnsupportedOperationException("remove");
    }
}

