/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.convert;

import java.util.Calendar;
import java.util.Date;
import org.seasar.util.convert.DateConversionUtil;
import org.seasar.util.misc.AssertionUtil;

public abstract class CalendarConversionUtil {
    public static Calendar toCalendar(Object o) {
        return CalendarConversionUtil.toCalendar(o, null);
    }

    public static Calendar toCalendar(Object o, String pattern) {
        if (o instanceof Calendar) {
            return (Calendar)o;
        }
        Date date = DateConversionUtil.toDate(o, pattern);
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        return null;
    }

    public static Calendar localize(Calendar calendar) {
        AssertionUtil.assertArgumentNotNull("calendar", calendar);
        Calendar localCalendar = Calendar.getInstance();
        localCalendar.setTimeInMillis(calendar.getTimeInMillis());
        return localCalendar;
    }
}

