/*
 * Copyright 2004-2006 H2 Group. Licensed under the H2 License, Version 1.0 (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package org.h2.util;

import org.h2.engine.Constants;
import org.h2.message.Message;

public abstract class CacheObject {
    private boolean changed;
    public CacheObject previous, next, chained;
    private int blockCount;
    private int pos;
    
    public void setBlockCount(int size) {
        this.blockCount = size;
    }
    
    public int getBlockCount() {
        return blockCount;
    }
    
    public void setPos(int pos) {
        if(Constants.CHECK && (previous!=null || next!=null || chained!=null)) {
            throw Message.internal("setPos too late");
        }
        this.pos = pos;
    }
    
    public int getPos() {
        return pos;
    }    

    public boolean isChanged() {
        return changed;
    }
    
    public void setChanged(boolean b) {
        changed = b;
    }   
        
    public boolean isPinned() {
        return false;
    }    
    
    public boolean canRemove() {
        return true;
    }

}
