/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.framework.util.BooleanConversionUtil;

public class BooleanType
extends AbstractValueType {
    public BooleanType() {
        super(16);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return BooleanConversionUtil.toBoolean((Object)resultSet.getObject(index));
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return BooleanConversionUtil.toBoolean((Object)resultSet.getObject(columnName));
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return BooleanConversionUtil.toBoolean((Object)cs.getObject(index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return BooleanConversionUtil.toBoolean((Object)cs.getObject(parameterName));
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setBoolean(index, BooleanConversionUtil.toPrimitiveBoolean((Object)value));
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setBoolean(parameterName, BooleanConversionUtil.toPrimitiveBoolean((Object)value));
        }
    }
}

