/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * BuriDataPathHistoryテーブルのEntityです。
 * @author S2Dao-CodeGen
 */


public abstract class AbstractBuriDataPathHistory {

	private Long historyID;
	private Long pathID;
	private Long dataID;
	private String userIDVal;
	private Integer userIDNum;
	private java.util.Date insertDate;
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * historyIDを返します。
	 * @return historyID
	 */
	@org.seasar.dao.annotation.tiger.Id(value=org.seasar.dao.annotation.tiger.IdType.ASSIGNED)
	@org.seasar.dao.annotation.tiger.Column("historyID")
	public Long getHistoryID() {
		return historyID;
	}

	/**
	 * historyIDを設定します。
	 * @param historyID historyID
	 */
	public void setHistoryID(Long historyID) {
		modifiedPropertySet.add("historyID");
		this.historyID = historyID;
	}

	/**
	 * PathIDを返します。
	 * @return PathID
	 */
	@org.seasar.dao.annotation.tiger.Column("PathID")
	public Long getPathID() {
		return pathID;
	}

	/**
	 * PathIDを設定します。
	 * @param pathID PathID
	 */
	public void setPathID(Long pathID) {
		modifiedPropertySet.add("pathID");
		this.pathID = pathID;
	}

	/**
	 * DataIDを返します。
	 * @return DataID
	 */
	@org.seasar.dao.annotation.tiger.Column("DataID")
	public Long getDataID() {
		return dataID;
	}

	/**
	 * DataIDを設定します。
	 * @param dataID DataID
	 */
	public void setDataID(Long dataID) {
		modifiedPropertySet.add("dataID");
		this.dataID = dataID;
	}

	/**
	 * UserIDValを返します。
	 * @return UserIDVal
	 */
	@org.seasar.dao.annotation.tiger.Column("UserIDVal")
	public String getUserIDVal() {
		return userIDVal;
	}

	/**
	 * UserIDValを設定します。
	 * @param userIDVal UserIDVal
	 */
	public void setUserIDVal(String userIDVal) {
		modifiedPropertySet.add("userIDVal");
		this.userIDVal = userIDVal;
	}

	/**
	 * UserIDNumを返します。
	 * @return UserIDNum
	 */
	@org.seasar.dao.annotation.tiger.Column("UserIDNum")
	public Integer getUserIDNum() {
		return userIDNum;
	}

	/**
	 * UserIDNumを設定します。
	 * @param userIDNum UserIDNum
	 */
	public void setUserIDNum(Integer userIDNum) {
		modifiedPropertySet.add("userIDNum");
		this.userIDNum = userIDNum;
	}

	/**
	 * insertDateを返します。
	 * @return insertDate
	 */
	@org.seasar.dao.annotation.tiger.Column("insertDate")
	public java.util.Date getInsertDate() {
		return insertDate;
	}

	/**
	 * insertDateを設定します。
	 * @param insertDate insertDate
	 */
	public void setInsertDate(java.util.Date insertDate) {
		modifiedPropertySet.add("insertDate");
		this.insertDate = insertDate;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/historyID=").append(historyID);
		buff.append("/pathID=").append(pathID);
		buff.append("/dataID=").append(dataID);
		buff.append("/userIDVal=").append(userIDVal);
		buff.append("/userIDNum=").append(userIDNum);
		buff.append("/insertDate=").append(insertDate);
		buff.append("]");
		return buff.toString();
	}

}
