/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.dao;

import java.util.List;

import org.seasar.codegen.sample.entity.BuriDataPathHistory;
import org.seasar.codegen.sample.condition.BuriDataPathHistoryCondition;
import org.seasar.codegen.sample.entity.BuriDataPathHistoryRelation;
import org.seasar.codegen.sample.condition.BuriDataPathHistoryRelationCondition;
/**
 * BuriDataPathHistoryテーブルに対応するDaoの中核部分です。
 * このDaoはgeneration gapを使用しているので、処理を追加するときはBuriDataPathHistoryDaoに処理を記述します。
 * @author S2Dao-CodeGen
 */
@org.seasar.dao.annotation.tiger.S2Dao(bean = BuriDataPathHistory.class)
@org.seasar.codegen.lib.annotation.SqlFileEncoding("UTF-8")
public interface BuriDataPathHistoryCore {

	/**
	 * BuriDataPathHistoryのEntityを全て取得します。主キーが複合主キーでない場合は主キーでソートします。
	 *
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Query("ORDER BY historyID")
	public List<BuriDataPathHistory> getAllBuriDataPathHistory();


	/**
	 * 引数が主キーと一致するBuriDataPathHistoryのEntityを取得します。
	 *
	 * @param historyID 主キー
	 * @return Entity。一致しない場合は<code>null</code>
	 */
	@org.seasar.dao.annotation.tiger.Query("historyID = ?")
	public BuriDataPathHistory getBuriDataPathHistory(Long historyID);


	/**
	 * 引数が主キーと一致するBuriDataPathHistoryのEntityのリストを主キーでソートして取得します。
	 *
	 * @param historyIDs  主キーの配列
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("historyIDs")
	@org.seasar.dao.annotation.tiger.Query("historyID in /*historyIDs*/(1) ORDER BY historyID")
	public List<BuriDataPathHistory> getBuriDataPathHistoryByIds(Long ... historyIDs);
	

	/**
	 * Conditionに指定した検索条件と一致するEntityのリストを取得します。
	 *
	 * @param dto 検索条件を指定したCondition
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("condition")
	public List<BuriDataPathHistory> find(BuriDataPathHistoryCondition condition);

	/**
	 * Conditionに指定した検索条件と一致するEntityを取得します。
	 *
	 * @param dto 検索条件を指定したFindDto
	 * @return Entityに対応するDto。一致しない場合は<code>null</code>
	 * @throws org.seasar.dao.NotSingleResultRuntimeException 結果が2件以上だった場合
	 */
	public BuriDataPathHistory soleMatch(BuriDataPathHistoryCondition condition);


	/**
	 * BuriDataPathHistoryのEntityを関連先も含めて全て取得します。主キーが複合主キーでない場合は主キーでソートします。
	 *
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Query("ORDER BY historyID")
	public List<BuriDataPathHistoryRelation> getAllBuriDataPathHistoryWithRelation();


	/**
	 * 引数が主キーと一致するBuriDataPathHistoryのEntityを関連先も含めて取得します。
	 *
	 * @param historyID 主キー
	 * @return Entity。一致しない場合は<code>null</code>
	 */
	@org.seasar.dao.annotation.tiger.Query("HistoryID  = ? ORDER BY historyID")
	public BuriDataPathHistoryRelation getBuriDataPathHistoryWithRelation(Long historyID);


	/**
	 * 引数が主キーと一致するBuriDataPathHistoryのEntityのリストを関連先も含めて主キーでソートして取得します。
	 *
	 * @param historyIDs  主キーの配列
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("historyIDs")
	@org.seasar.dao.annotation.tiger.Query("historyID in /*historyIDs*/(1) ORDER BY historyID")
	public List<BuriDataPathHistoryRelation> getBuriDataPathHistoryByIdsWithRelation(Object ... historyIDs);
	
	/**
	 * Conditionに指定した検索条件と一致するEntityのリストを関連先も含めて取得します。
	 *
	 * @param condition 検索条件を指定したCondition
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("condition")
	public List<BuriDataPathHistoryRelation> findWithRelation(BuriDataPathHistoryRelationCondition condition);

	/**
	 * Conditionに指定した検索条件と一致するEntityを関連先も含めて取得します。
	 *
	 * @param condition 検索条件を指定したCondition
	 * @return Entityのリスト。一致しない場合は<code>null</code>
	 * @throws org.seasar.dao.NotSingleResultRuntimeException 結果が2件以上だった場合
	 */
	public BuriDataPathHistoryRelation soleMatchWithRelation(BuriDataPathHistoryRelationCondition condition);
	/**
	 * Entityを追加します。
	 *
	 * @param entity 追加するEntity
	 */
	public void insert(BuriDataPathHistory entity);
	/**
	 * Entityを更新します。
	 *
	 * @param entity 更新するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void update(BuriDataPathHistory entity);

	/**
	 * Entityを削除します。
	 *
	 * @param entity 削除するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void delete(BuriDataPathHistory entity);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します.	 
	 *
	 * @param entity 更新するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void updateModifiedOnly(BuriDataPathHistory entity);

	/**
	 * Entityを更新します。このメソッドは更新結果が0件の時例外を投げません。
	 * @param entity Entity
	 * @return 更新結果の件数
	 */
	 @org.seasar.dao.annotation.tiger.CheckSingleRowUpdate(false)
	 public int updateNonCheck(BuriDataPathHistory entity);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します。このメソッドは更新結果が0件の時例外を返しません。
	 * @param entity Entity
	 * @return 更新結果の件数
	 */
	@org.seasar.dao.annotation.tiger.CheckSingleRowUpdate(false)
	public int updateNonCheckModifiedOnly(BuriDataPathHistory entity);
	/**
	 * 追加をバッチ更新で行います。
	 * @param entityList 追加するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] insertBatch(List<BuriDataPathHistory> entityList);
	/**
	 * 更新をバッチ更新で行います。
	 * @param entityList 更新するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] updateBatch(List<BuriDataPathHistory> entityList);

	/**
	 * 削除をバッチ更新で行います。
	 * @param EntityList 削除するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] deleteBatch(List<BuriDataPathHistory> entityList);

}

