/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.impl;

import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.seasar.codegen.CodeGenConfig;
import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.convert.FKNameConverter;
import org.seasar.codegen.dbms.Dbms;
import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.FieldSetting;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.PrimaryKey;
import org.seasar.codegen.element.Table;
import org.seasar.codegen.exception.InternalGenerateException;
import org.seasar.codegen.exception.NotTypeMatchException;
import org.seasar.codegen.util.CreateTableTypeToTypeUtil;
import org.seasar.codegen.util.ExcelUtil;
import org.seasar.codegen.util.IdentityUtil;
import org.seasar.codegen.util.LinkUtil;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExcelImportCodeDataSupport
implements ImportCodeData {
    protected FKNameConverter converter;
    protected int attributeNameCol;
    protected int columnNameCol;
    protected int dataTypeCol;
    protected int notNullCol;
    protected int primaryKeyCol;
    protected int foreignKeyCol;
    protected int defaultValueCol;
    protected int relationTypeCol;
    protected int parentTableCol;
    protected int parentColumnCol;
    protected int cardinalityCol;
    protected int parentPropertyCol;
    protected int childPropertyCol;
    protected Dbms dataTypeSelectUtil;
    protected static final String IDENTITY = "identity";
    protected static final String SEQUENCE = "sequence";
    @Binding(bindingType=BindingType.MUST)
    protected CodeGenConfig codeGenConfig;

    public void setDbms(Dbms dataTypeSelectUtil) {
        this.dataTypeSelectUtil = dataTypeSelectUtil;
    }

    protected Field getField(HSSFRow row, Table table) {
        String columnName = this.getString(row, this.columnNameCol);
        if (StringUtil.isEmpty((String)columnName)) {
            return null;
        }
        Field field = new Field();
        field.setFieldName(columnName);
        try {
            field.setDataType(this.getDataType(row));
        }
        catch (InternalGenerateException e) {
            throw new NotTypeMatchException(table.getTableName(), columnName, e);
        }
        field.setFieldAttributeName(this.getString(row, this.attributeNameCol));
        return field;
    }

    protected DataType getDataType(HSSFRow row) throws InternalGenerateException {
        String dataType = this.getString(row, this.dataTypeCol);
        String notNull = this.getString(row, this.notNullCol);
        String defaultValue = this.getString(row, this.defaultValueCol);
        return this.getDataType(dataType, notNull, defaultValue);
    }

    protected DataType getDataType(String dataType, String notNull, String defaultValue) throws InternalGenerateException {
        FieldSetting fieldSetting = new FieldSetting();
        String typeName = CreateTableTypeToTypeUtil.getTypeName(dataType);
        String langType = this.dataTypeSelectUtil.convDBTypeToDataType(typeName);
        fieldSetting.setTypeName(langType);
        String length = CreateTableTypeToTypeUtil.getLength(dataType, typeName);
        int precision = CreateTableTypeToTypeUtil.getFullLength(length);
        fieldSetting.setColmnSize(precision);
        int scale = CreateTableTypeToTypeUtil.getPointNumberLength(length);
        fieldSetting.setPointNumber(scale);
        boolean isNotNull = "NOT NULL".equalsIgnoreCase(notNull);
        fieldSetting.setNotNull(isNotNull);
        fieldSetting.setFieldDefault(defaultValue);
        DataType type = this.dataTypeSelectUtil.selectBestDataType(fieldSetting);
        return type;
    }

    protected PrimaryKey getPrimaryKey(HSSFRow row, Field field) {
        String isPrimaryKey = this.getString(row, this.primaryKeyCol);
        if (StringUtil.isEmpty((String)isPrimaryKey)) {
            return null;
        }
        if ((isPrimaryKey = isPrimaryKey.trim()).equalsIgnoreCase(IDENTITY)) {
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.setField(field);
            field.setUseIdentity(true);
            return primaryKey;
        }
        if (isPrimaryKey.startsWith("\"") && isPrimaryKey.endsWith("\"")) {
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.setField(field);
            field.setSequence(isPrimaryKey.replaceAll("\"", ""));
            return primaryKey;
        }
        if (IdentityUtil.isTrue(isPrimaryKey)) {
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.setField(field);
            if (this.codeGenConfig.getIdentityType() != null) {
                if (IdentityUtil.isIdentityConfig(this.codeGenConfig.getIdentityType().trim())) {
                    field.setUseIdentity(true);
                } else if (IdentityUtil.isSequenceConfig(this.codeGenConfig.getIdentityType())) {
                    field.setSequence(field.getFieldNameForDto());
                }
                return primaryKey;
            }
            field.setSequence(field.getFieldNameForDto());
            return primaryKey;
        }
        return null;
    }

    protected LinkTable getParentLink(HSSFRow row, Field field) {
        String relationType = this.getString(row, this.relationTypeCol);
        if (StringUtil.isEmpty((String)relationType)) {
            return null;
        }
        LinkTable link = new LinkTable();
        link.setTableName(this.getString(row, this.parentTableCol));
        link.setParentFieldName(this.getString(row, this.parentColumnCol));
        link.setChildFieldName(field.getFieldName());
        return link;
    }

    protected void setupChildLinks(Map<String, Table> tableMap) {
        LinkUtil.setupChildLinks(tableMap);
    }

    protected String getString(HSSFSheet sheet, int row, int col) {
        return ExcelUtil.getString(sheet, row, col);
    }

    protected String getString(HSSFRow row, int col) {
        return ExcelUtil.getString(row, col);
    }

    public void setCodeGenConfig(CodeGenConfig codeGenConfig) {
        this.codeGenConfig = codeGenConfig;
    }

    public void setFKNameConverter(FKNameConverter converter) {
        this.converter = converter;
    }
}

