/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.framework.exception.IORuntimeException;

public class ExcelUtil {
    public static HSSFWorkbook createWorkbook(InputStream in) {
        try {
            return new HSSFWorkbook(in);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static HSSFCell getCell(HSSFSheet sheet, int row, int col) {
        return ExcelUtil.getCell(sheet.getRow(row), col);
    }

    public static HSSFCell getCell(HSSFRow row, int col) {
        if (row == null) {
            return null;
        }
        return row.getCell((short)col);
    }

    public static String getString(HSSFSheet sheet, int row, int col) {
        return ExcelUtil.getString(ExcelUtil.getCell(sheet, row, col));
    }

    public static String getString(HSSFRow row, int col) {
        return ExcelUtil.getString(ExcelUtil.getCell(row, col));
    }

    public static String getString(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        int type = cell.getCellType();
        switch (type) {
            case 4: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case 0: {
                double value = cell.getNumericCellValue();
                if (ExcelUtil.isInt(value)) {
                    return Integer.toString((int)value);
                }
                return Double.toString(value);
            }
            case 1: {
                return ExcelUtil.trim(cell.getRichStringCellValue().getString());
            }
        }
        return "";
    }

    protected static boolean isInt(double numericCellValue) {
        return (double)((int)numericCellValue) == numericCellValue;
    }

    private static String trim(String s) {
        return s == null ? s : s.trim();
    }
}

