/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jiemamy.FacetProvider;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.JmForeignKeyConstraint;
import org.jiemamy.model.constraint.JmPrimaryKeyConstraint;
import org.jiemamy.model.datatype.TypeParameterKey;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.serializer.JiemamySerializer;
import org.jiemamy.serializer.SerializationException;
import org.seasar.codegen.CodeGenConfig;
import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.convert.FKNameConverter;
import org.seasar.codegen.dbms.Dbms;
import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.FieldSetting;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.PrimaryKey;
import org.seasar.codegen.element.Table;
import org.seasar.codegen.exception.CodeGenException;
import org.seasar.codegen.exception.InternalGenerateException;
import org.seasar.codegen.exception.NotTypeMatchException;
import org.seasar.codegen.util.LinkUtil;
import org.seasar.codegen.util.SequnceUtil;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiemamyImportCodeData
implements ImportCodeData {
    private Dbms dbms;
    private FKNameConverter converter;
    @Binding(bindingType=BindingType.MUST)
    private CodeGenConfig codeGenConfig;

    @Override
    public Map<String, Table> readCodeData(File srcFile) {
        JiemamyContext context;
        JiemamySerializer serializer = JiemamyContext.findSerializer();
        try {
            context = this.deserialize(srcFile, serializer);
        }
        catch (FileNotFoundException e) {
            throw new CodeGenException("ECDG0004", e);
        }
        catch (SerializationException e) {
            throw new CodeGenException("ECDG0004", e);
        }
        Set tableSet = context.getTables();
        HashMap<String, Table> tableMap = new HashMap<String, Table>();
        for (JmTable jmTable : tableSet) {
            Table table = this.getTable(jmTable);
            List<LinkTable> parentLink = this.getParentLink(tableSet, jmTable, table);
            for (LinkTable linkTable : parentLink) {
                String relName = this.converter.convertParent(table, linkTable);
                table.addLinkTable(relName, linkTable);
            }
            tableMap.put(table.getTableName(), table);
        }
        this.setupChildLinks(tableMap);
        return tableMap;
    }

    JiemamyContext deserialize(File srcFile, JiemamySerializer serializer) throws SerializationException, FileNotFoundException {
        return serializer.deserialize((InputStream)new FileInputStream(srcFile), new FacetProvider[0]);
    }

    Table getTable(JmTable jmTable) {
        String tableName = jmTable.getName();
        Table table = new Table();
        table.setTableName(tableName);
        List columnModels = jmTable.getColumns();
        for (JmColumn columnModel : columnModels) {
            Field field = this.getField(columnModel, jmTable);
            table.addTableField(field);
            PrimaryKey primaryKey = this.getPrimaryKey(jmTable, field);
            if (primaryKey == null) continue;
            table.addPrimaryKey(primaryKey);
        }
        return table;
    }

    Field getField(JmColumn jmColumn, JmTable jmTable) {
        Integer ilength;
        Field field = new Field();
        field.setFieldName(jmColumn.getName());
        FieldSetting fieldSetting = new FieldSetting();
        String langType = this.dbms.convDBTypeToDataType(jmColumn.getDataType().getRawTypeDescriptor().getTypeName());
        fieldSetting.setTypeName(langType);
        int length = 0;
        if (jmColumn.getDataType().getParam(TypeParameterKey.SIZE) != null && (ilength = (Integer)jmColumn.getDataType().getParam(TypeParameterKey.SIZE)) != null) {
            length = ilength;
        }
        int scale = 0;
        if (jmColumn.getDataType().getParam(TypeParameterKey.SCALE) != null) {
            scale = (Integer)jmColumn.getDataType().getParam(TypeParameterKey.SCALE);
        }
        if (jmColumn.getDataType().getParam(TypeParameterKey.PRECISION) != null) {
            length = (Integer)jmColumn.getDataType().getParam(TypeParameterKey.PRECISION);
        }
        fieldSetting.setColmnSize(length);
        fieldSetting.setPointNumber(scale);
        if (jmTable.isNotNullColumn((EntityRef)new DefaultEntityRef((Entity)jmColumn))) {
            fieldSetting.setNotNull(true);
        }
        fieldSetting.setFieldDefault(jmColumn.getDefaultValue() == null ? "" : jmColumn.getDefaultValue());
        DataType dataType = null;
        try {
            dataType = this.dbms.selectBestDataType(fieldSetting);
        }
        catch (InternalGenerateException e) {
            throw new NotTypeMatchException(jmTable.getName(), jmColumn.getName(), e);
        }
        field.setDataType(dataType);
        if (StringUtil.isEmpty((String)jmColumn.getLogicalName())) {
            field.setFieldAttributeName(jmColumn.getName());
        } else {
            field.setFieldAttributeName(jmColumn.getLogicalName());
        }
        return field;
    }

    PrimaryKey getPrimaryKey(JmTable jmTable, Field field) {
        if (jmTable.getPrimaryKey() != null) {
            JmPrimaryKeyConstraint keyConstraint = jmTable.getPrimaryKey();
            for (EntityRef columnRef : keyConstraint.getKeyColumns()) {
                Map<String, String> sequenceMap;
                JmColumn jmColumn = jmTable.getColumn(columnRef);
                if (!jmColumn.getName().equals(field.getFieldName())) continue;
                PrimaryKey primaryKey = new PrimaryKey();
                primaryKey.setField(field);
                if (jmColumn.getDataType() != null && jmColumn.getDataType().getParam(TypeParameterKey.SERIAL) != null && ((Boolean)jmColumn.getDataType().getParam(TypeParameterKey.SERIAL)).booleanValue()) {
                    field.setUseIdentity(true);
                }
                if ((sequenceMap = this.codeGenConfig.getSequnceMapping()) != null) {
                    String sequenceName = sequenceMap.get(jmTable.getName());
                    SequnceUtil.addSequence(primaryKey, sequenceName);
                }
                return primaryKey;
            }
        }
        return null;
    }

    List<LinkTable> getParentLink(Set<JmTable> tableSet, JmTable jmTable, Table table) {
        Collection foreignKeys = jmTable.getForeignKeyConstraints();
        ArrayList<LinkTable> linkTables = new ArrayList<LinkTable>(foreignKeys.size());
        for (JmForeignKeyConstraint foreignKey : foreignKeys) {
            LinkTable linkTable = new LinkTable();
            linkTable.setChildFieldName(this.findColumn(jmTable, foreignKey.getKeyColumns(), linkTable));
            JmTable parentTable = foreignKey.findReferenceTable(tableSet);
            linkTable.setParentFieldName(this.findColumn(parentTable, foreignKey.getReferenceColumns(), linkTable));
            linkTable.setTableName(parentTable.getName());
            linkTables.add(linkTable);
        }
        return linkTables;
    }

    private String findColumn(JmTable jmTable, List<EntityRef<? extends JmColumn>> keyColumns, LinkTable linkTable) {
        for (EntityRef<? extends JmColumn> entityRef : keyColumns) {
            for (JmColumn column : jmTable.getColumns()) {
                if (!column.getId().equals(entityRef.getReferentId())) continue;
                return column.getName();
            }
        }
        throw new UnsupportedOperationException();
    }

    private void setupChildLinks(Map<String, Table> tableMap) {
        LinkUtil.setupChildLinks(tableMap);
    }

    public void setFKNameConverter(FKNameConverter converter) {
        this.converter = converter;
    }

    public void setDbms(Dbms dbms) {
        this.dbms = dbms;
    }

    public void setCodeGenConfig(CodeGenConfig codeGenConfig) {
        this.codeGenConfig = codeGenConfig;
    }
}

