/*
 * Copyright 2004-2010 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.dbms;

import java.util.List;

import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.seasar.codegen.element.FieldSetting;

@RunWith(Parameterized.class)
public class MySQLTest extends AbstractDbmsTestCase {

    public MySQLTest(FieldSetting fieldSetting, String expectClassName) {
        super(fieldSetting, expectClassName);
    }

    @Parameters
    public static List<Object[]> getParameters() {
        List<String[]> parameters = readCSV("MySQL");
        return createParameter(parameters);
    }

    @Override
    protected Dbms createDbmsInstance() {
        return new MySQL();
    }

}
