/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.annotation.tiger.util;

import java.lang.annotation.Annotation;
import org.seasar.dao.util.ImplementInterfaceWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtil {
    private AnnotationUtil() {
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationClass) {
        return AnnotationUtil.getAnnotation0(clazz, annotationClass);
    }

    private static <T extends Annotation> T getAnnotation0(Class<?> clazz, Class<T> annotationClass) {
        T annotation = AnnotationUtil.getAnnotationFromClass(clazz, annotationClass);
        if (annotation != null) {
            return annotation;
        }
        for (Class<?> testClass = clazz; annotation == null && testClass != null && testClass != Object.class; testClass = testClass.getSuperclass()) {
            HandlerImpl<T> handlerImpl = new HandlerImpl<T>(annotationClass);
            ImplementInterfaceWalker.walk(testClass, handlerImpl);
            annotation = handlerImpl.foundClass;
        }
        return annotation;
    }

    private static <T extends Annotation> T getAnnotationFromClass(Class<?> clazz, Class<T> annotationClass) {
        if (clazz.isAnnotationPresent(annotationClass)) {
            return clazz.getAnnotation(annotationClass);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HandlerImpl<T extends Annotation>
    implements ImplementInterfaceWalker.Handler {
        T foundClass;
        private Class<T> annotationClass;

        public HandlerImpl(Class<T> annotationClass) {
            this.annotationClass = annotationClass;
        }

        public ImplementInterfaceWalker.Status accept(Class ifs) {
            Annotation beanClass = AnnotationUtil.getAnnotationFromClass(ifs, this.annotationClass);
            if (beanClass != null) {
                this.foundClass = beanClass;
                return ImplementInterfaceWalker.BREAK;
            }
            return ImplementInterfaceWalker.CONTINUE;
        }
    }
}

