/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.interceptors;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.DaoMetaDataFactory;
import org.seasar.dao.SqlCommand;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.NumberConversionUtil;

public class S2DaoInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private DaoMetaDataFactory daoMetaDataFactory;

    public S2DaoInterceptor(DaoMetaDataFactory daoMetaDataFactory) {
        this.daoMetaDataFactory = daoMetaDataFactory;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!MethodUtil.isAbstract((Method)method)) {
            return invocation.proceed();
        }
        Class targetClass = this.getTargetClass(invocation);
        DaoMetaData dmd = this.daoMetaDataFactory.getDaoMetaData(targetClass);
        SqlCommand cmd = dmd.getSqlCommand(method.getName());
        Object ret = cmd.execute(invocation.getArguments());
        Class<?> retType = method.getReturnType();
        if (retType.isPrimitive()) {
            return NumberConversionUtil.convertPrimitiveWrapper(retType, (Object)ret);
        }
        if (Number.class.isAssignableFrom(retType)) {
            return NumberConversionUtil.convertNumber(retType, (Object)ret);
        }
        return ret;
    }
}

