/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.RelationPropertyType;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.RowCreator;
import org.seasar.dao.impl.AbstractBeanMetaDataResultSetHandler;
import org.seasar.dao.impl.RelationKey;
import org.seasar.dao.impl.RelationRowCache;
import org.seasar.framework.beans.PropertyDesc;

public class BeanListMetaDataResultSetHandler
extends AbstractBeanMetaDataResultSetHandler {
    public BeanListMetaDataResultSetHandler(BeanMetaData beanMetaData, RowCreator rowCreator, RelationRowCreator relationRowCreator) {
        super(beanMetaData, rowCreator, relationRowCreator);
    }

    public Object handle(ResultSet rs) throws SQLException {
        Set columnNames = this.createColumnNames(rs.getMetaData());
        Map propertyCache = null;
        Map relationPropertyCache = null;
        ArrayList<Object> list = new ArrayList<Object>();
        int relSize = this.getBeanMetaData().getRelationPropertyTypeSize();
        RelationRowCache relRowCache = new RelationRowCache(relSize);
        while (rs.next()) {
            if (propertyCache == null) {
                propertyCache = this.createPropertyCache(columnNames);
            }
            if (relationPropertyCache == null) {
                relationPropertyCache = this.createRelationPropertyCache(columnNames);
            }
            Object row = this.createRow(rs, propertyCache);
            for (int i = 0; i < relSize; ++i) {
                RelationPropertyType rpt = this.getBeanMetaData().getRelationPropertyType(i);
                if (rpt == null) continue;
                Object relationRow = null;
                HashMap relKeyValues = new HashMap();
                RelationKey relKey = this.createRelationKey(rs, rpt, columnNames, relKeyValues);
                if (relKey != null && (relationRow = relRowCache.getRelationRow(i, relKey)) == null) {
                    relationRow = this.createRelationRow(rs, rpt, columnNames, relKeyValues, relationPropertyCache);
                    relRowCache.addRelationRow(i, relKey, relationRow);
                }
                if (relationRow == null) continue;
                PropertyDesc pd = rpt.getPropertyDesc();
                pd.setValue(row, relationRow);
                this.postCreateRow(relationRow);
            }
            this.postCreateRow(row);
            list.add(row);
        }
        return list;
    }
}

