/*
 * Decompiled with CFR 0.152.
 */
package jp.starlogic.servicemanager.service;

import java.util.Calendar;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import jp.starlogic.servicemanager.abst.AbstractCronTypeService;
import jp.starlogic.util.datetime.CalendarUtil;
import jp.starlogic.util.datetime.DateUtil;
import jp.starlogic.util.datetime.UtilCalendar;
import org.seasar.buri.common.util.ScriptProcessor;
import org.seasar.framework.container.S2Container;

public class CronTypeService
extends AbstractCronTypeService {
    private String executeStr = "";
    private S2Container container;
    private Integer exeYear = null;
    private Integer exeMonth = null;
    private Integer exeDay = null;
    private TreeSet exeWeek = new TreeSet();
    private Integer exeHour = null;
    private Integer exeMinute = null;
    private Integer exeSecond = null;
    private Boolean lastDayOfMonth = Boolean.FALSE;
    private Boolean nearestWeekday = Boolean.FALSE;
    private Boolean nearestHoliday = Boolean.FALSE;
    private Boolean firstDayOfMonth = Boolean.FALSE;

    public Calendar createNext(Calendar now) {
        UtilCalendar nowCal = (UtilCalendar)UtilCalendar.getInstance();
        nowCal.setTimeInMillis(now.getTimeInMillis());
        return this.createNextRunCalender(nowCal);
    }

    protected UtilCalendar createNextRunCalender(UtilCalendar lastRun) {
        UtilCalendar result = (UtilCalendar)lastRun.clone();
        UtilCalendar prev = (UtilCalendar)result.clone();
        result.clearMilliSecond();
        boolean changeSecToHour = false;
        if (this.exeSecond != null) {
            result.setSecond(this.exeSecond);
            if (DateUtil.compare((Calendar)prev, (Calendar)result) >= 0L) {
                result.addMinute(1);
            }
            changeSecToHour = true;
        }
        if (this.exeMinute != null) {
            result.setMinute(this.exeMinute);
            if (DateUtil.compare((Calendar)prev, (Calendar)result) >= 0L) {
                result.addHourOfDay(1);
            }
            changeSecToHour = true;
        }
        if (this.exeHour != null) {
            result.setHourOfDay(this.exeHour);
            if (DateUtil.compare((Calendar)prev, (Calendar)result) >= 0L) {
                result.addDayOfMonth(1);
            }
            changeSecToHour = true;
        }
        boolean isChangeDayOfMonth = false;
        if (this.exeWeek.size() > 0) {
            isChangeDayOfMonth = this.updateWeek(result);
        } else if (this.lastDayOfMonth.booleanValue()) {
            CalendarUtil.setActualMaximum(result, 5);
            if (DateUtil.compare((Calendar)prev, (Calendar)result) >= 0L) {
                result.addMonth(1);
                CalendarUtil.setActualMaximum(result, 5);
            }
            isChangeDayOfMonth = true;
        } else if (this.firstDayOfMonth.booleanValue()) {
            CalendarUtil.setActualMinimum(result, 5);
            if (DateUtil.compare((Calendar)prev, (Calendar)result) >= 0L) {
                result.addMonth(1);
            }
            isChangeDayOfMonth = true;
        } else if (this.nearestWeekday.booleanValue()) {
            result.setDayOfMonth(prev.getDayOfMonth());
            result.nextWeekday();
            isChangeDayOfMonth = true;
        } else if (this.nearestHoliday.booleanValue()) {
            result.setDayOfMonth(prev.getDayOfMonth());
            result.nextHoliday();
            isChangeDayOfMonth = true;
        } else if (this.exeDay != null) {
            result.setDayOfMonth(this.exeDay);
            isChangeDayOfMonth = true;
        } else if (changeSecToHour && DateUtil.compare((Calendar)prev, (Calendar)result) >= 0L) {
            result.addDayOfMonth(1);
        }
        if (isChangeDayOfMonth && DateUtil.compare((Calendar)prev, (Calendar)result) >= 0L) {
            result.addMonth(1);
        }
        if (this.exeMonth != null) {
            result.setMonth(this.exeMonth);
            if (DateUtil.compare((Calendar)prev, (Calendar)result) >= 0L) {
                result.addYear(1);
            }
        }
        if (this.exeYear != null) {
            result.setMonth(this.exeYear);
        }
        return result;
    }

    protected boolean updateWeek(UtilCalendar lastRun) {
        boolean isChangeDayOfMonth = false;
        int weekNo = lastRun.get(7);
        SortedSet<Integer> st = this.exeWeek.tailSet(new Integer(weekNo + 1));
        int updateVal = 0;
        if (st != null && st.size() != 0) {
            updateVal = st.first();
            int updateCount = (updateVal + 7 - weekNo) % 7;
            if (updateCount == 0) {
                updateCount = 7;
            }
            lastRun.addDayOfMonth(updateCount);
            isChangeDayOfMonth = true;
        } else if (this.exeWeek.size() != 0) {
            updateVal = (Integer)this.exeWeek.first();
            int updateCount = (updateVal + 7 - weekNo) % 7;
            if (updateCount == 0) {
                updateCount = 7;
            }
            lastRun.addDayOfMonth(updateCount);
            isChangeDayOfMonth = true;
        }
        return isChangeDayOfMonth;
    }

    protected int updateNextRunField(UtilCalendar lastRun, int field, TreeSet tgtSet) {
        int fieldVal = (lastRun = (UtilCalendar)lastRun.clone()).get(field);
        SortedSet<Integer> st = tgtSet.tailSet(new Integer(fieldVal));
        if (st != null && st.size() != 0) {
            int updateVal = st.first();
            lastRun.set(field, updateVal);
        } else if (tgtSet.size() != 0) {
            int updateVal = (Integer)tgtSet.first();
            CalendarUtil.setActualMaximum(lastRun, field);
            lastRun.add(field, 1);
            lastRun.set(field, updateVal);
        }
        return lastRun.get(field);
    }

    protected void executeCron() {
        ScriptProcessor processor = new ScriptProcessor();
        processor.getValue(this.executeStr, this.container);
    }

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public String getExecuteStr() {
        return this.executeStr;
    }

    public void setExecuteStr(String executeStr) {
        this.executeStr = executeStr;
    }

    public Boolean getFirstDayOfMonth() {
        return this.firstDayOfMonth;
    }

    public void setFirstDayOfMonth(Boolean fastDayOfMonth) {
        this.firstDayOfMonth = fastDayOfMonth;
    }

    public Boolean getLastDayOfMonth() {
        return this.lastDayOfMonth;
    }

    public void setLastDayOfMonth(Boolean lastDayOfMonth) {
        this.lastDayOfMonth = lastDayOfMonth;
    }

    public Boolean getNearestHoliday() {
        return this.nearestHoliday;
    }

    public void setNearestHoliday(Boolean nearestHoliday) {
        this.nearestHoliday = nearestHoliday;
    }

    public Boolean getNearestWeekday() {
        return this.nearestWeekday;
    }

    public void setNearestWeekday(Boolean nearestWeekday) {
        this.nearestWeekday = nearestWeekday;
    }

    public int getExeDay() {
        return this.exeDay;
    }

    public void setExeDay(int exeDay) {
        this.exeDay = new Integer(exeDay);
    }

    public int getExeHour() {
        return this.exeHour;
    }

    public void setExeHour(int exeHour) {
        this.exeHour = new Integer(exeHour);
    }

    public int getExeMinute() {
        return this.exeMinute;
    }

    public void setExeMinute(int exeMinute) {
        this.exeMinute = new Integer(exeMinute);
    }

    public int getExeMonth() {
        return this.exeMonth;
    }

    public void setExeMonth(int exeMonth) {
        this.exeMonth = new Integer(exeMonth);
    }

    public int getExeSecond() {
        return this.exeSecond;
    }

    public void setExeSecond(int exeSecond) {
        this.exeSecond = new Integer(exeSecond);
    }

    public TreeSet getExeWeek() {
        return this.exeWeek;
    }

    public void setExeWeek(List weekList) {
        this.exeWeek.addAll(weekList);
    }

    public void setExeWeek(TreeSet exeWeek) {
        this.exeWeek = exeWeek;
    }

    public Integer getExeYear() {
        return this.exeYear;
    }

    public void setExeYear(Integer exeYear) {
        this.exeYear = exeYear;
    }
}

