/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.parameter;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyError;
import org.jiemamy.dddbase.utils.CloneUtil;
import org.jiemamy.model.parameter.Converter;
import org.jiemamy.model.parameter.ParameterKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParameterMap
implements Iterable<Map.Entry<String, String>>,
Cloneable {
    HashMap<String, String> map = Maps.newHashMap();

    public ParameterMap clone() {
        try {
            ParameterMap clone = (ParameterMap)super.clone();
            clone.map = CloneUtil.cloneValueHashMap(this.map);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new JiemamyError("clone must to be supported.", (Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterMap other = (ParameterMap)obj;
        return this.map.equals(other.map);
    }

    public <T> T get(ParameterKey<T> key) {
        Validate.notNull(key);
        if (!this.map.containsKey(key.getKeyString())) {
            return null;
        }
        Converter<T> converter = key.getConverter();
        String string = this.map.get(key.getKeyString());
        if (string == null) {
            return null;
        }
        return converter.valueOf(string);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.map.entrySet().iterator();
    }

    public <T> T put(ParameterKey<T> key, T value) {
        Validate.notNull(key);
        Validate.notNull(value);
        Converter<T> converter = key.getConverter();
        if (!this.map.containsKey(key.getKeyString())) {
            this.map.put(key.getKeyString(), converter.toString(value));
            return null;
        }
        String old = this.map.put(key.getKeyString(), converter.toString(value));
        if (old == null) {
            return null;
        }
        return converter.valueOf(old);
    }

    public String put(String key, String value) {
        return this.map.put(key, value);
    }

    public <T> T remove(ParameterKey<T> key) {
        Validate.notNull(key);
        Converter<T> converter = key.getConverter();
        String string = this.map.remove(key.getKeyString());
        if (string == null) {
            return null;
        }
        return converter.valueOf(string);
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }
}

