/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import com.google.common.collect.Iterables;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.JmLocalKeyConstraint;
import org.jiemamy.model.constraint.SimpleJmForeignKeyConstraint;
import org.jiemamy.model.table.ColumnNotFoundException;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.model.table.TooManyColumnsFoundException;

public final class ForeignKeyFactory {
    public static SimpleJmForeignKeyConstraint create(JiemamyContext context, JmTable declaringTable, JmTable referenceTable) {
        return ForeignKeyFactory.setup(new SimpleJmForeignKeyConstraint(), context, declaringTable, referenceTable);
    }

    public static SimpleJmForeignKeyConstraint setup(SimpleJmForeignKeyConstraint fk, JiemamyContext context, JmTable declaringTable, JmTable referenceTable) {
        Validate.notNull((Object)fk);
        Validate.notNull((Object)context);
        Validate.notNull((Object)declaringTable);
        Validate.notNull((Object)referenceTable);
        JmLocalKeyConstraint key = referenceTable.getPrimaryKey();
        if (key == null) {
            Iterable lks = Iterables.filter(referenceTable.getConstraints(), JmLocalKeyConstraint.class);
            try {
                key = (JmLocalKeyConstraint)Iterables.get((Iterable)lks, (int)0);
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        if (key == null) {
            throw new IllegalArgumentException("no local keys in " + referenceTable);
        }
        fk.clearKeyColumns();
        int index = 0;
        for (EntityRef<? extends JmColumn> referenceColumnRef : key.getKeyColumns()) {
            JmColumn referenceColumn = context.resolve(referenceColumnRef);
            JmColumn keyColumn = ForeignKeyFactory.getColumn(declaringTable, referenceTable.getName() + "_" + referenceColumn.getName(), referenceTable.getName());
            if (keyColumn == null) {
                try {
                    keyColumn = (JmColumn)Iterables.get(declaringTable.getColumns(), (int)index++);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IllegalArgumentException();
                }
            }
            fk.addReferencing(keyColumn.toReference(), referenceColumnRef);
        }
        return fk;
    }

    private static JmColumn getColumn(JmTable table, String ... names) {
        for (String name : names) {
            try {
                return table.getColumn(name);
            }
            catch (ColumnNotFoundException e) {
            }
            catch (TooManyColumnsFoundException e) {
                return (JmColumn)Iterables.get(e.getColumns(), (int)0);
            }
        }
        return null;
    }

    private ForeignKeyFactory() {
    }
}

