/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.constraint;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.utils.CloneUtil;
import org.jiemamy.dddbase.utils.MutationMonitor;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.JmKeyConstraint;
import org.jiemamy.model.constraint.SimpleJmConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleJmKeyConstraint
extends SimpleJmConstraint
implements JmKeyConstraint {
    private List<EntityRef<? extends JmColumn>> keyColumns = Lists.newArrayList();

    public SimpleJmKeyConstraint(UUID id) {
        super(id);
    }

    public void addKeyColumn(EntityRef<? extends JmColumn> keyColumn) {
        Validate.notNull(keyColumn);
        this.keyColumns.add(keyColumn);
    }

    public void clearKeyColumns() {
        this.keyColumns.clear();
    }

    @Override
    public SimpleJmKeyConstraint clone() {
        SimpleJmKeyConstraint clone = (SimpleJmKeyConstraint)super.clone();
        clone.keyColumns = CloneUtil.cloneValueArrayList(this.keyColumns);
        return clone;
    }

    @Override
    public List<EntityRef<? extends JmColumn>> getKeyColumns() {
        return MutationMonitor.monitor((List)Lists.newArrayList(this.keyColumns));
    }

    public void removeKeyColumn(EntityRef<? extends JmColumn> keyColumn) {
        Validate.notNull(keyColumn);
        this.keyColumns.remove(keyColumn);
    }

    public EntityRef<? extends SimpleJmKeyConstraint> toReference() {
        return new DefaultEntityRef((Entity)this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.insert(sb.length() - 1, ", key=" + this.keyColumns);
        return sb.toString();
    }
}

