/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.collection;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.jiemamy.utils.collection.EssentialQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedEssentialQueue<E>
implements EssentialQueue<E> {
    LinkedList<E> linkedList = new LinkedList();

    @Override
    public void clear() {
        this.linkedList.clear();
    }

    @Override
    public E dequeue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.linkedList.poll();
    }

    @Override
    public void enqueue(E element) {
        this.linkedList.offer(element);
    }

    @Override
    public void enqueue(EssentialQueue<E> queue) {
        while (!queue.isEmpty()) {
            E element = queue.dequeue();
            this.enqueue(element);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.linkedList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.linkedList.iterator();
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.linkedList.peek();
    }

    @Override
    public int size() {
        return this.linkedList.size();
    }

    public String toString() {
        return this.linkedList.toString();
    }
}

