/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql.metadata;

import java.sql.ResultSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.utils.sql.ResultSetUtil;

public class KeyMeta {
    public final String pkTableCat;
    public final String pkTableSchem;
    public final String pkTableName;
    public final String pkColumnName;
    public final String fkTableCat;
    public final String fkTableSchem;
    public final String fkTableName;
    public final String fkColumnName;
    public final short keySeq;
    public final Rule updateRule;
    public final Rule deleteRule;
    public final String fkName;
    public final String pkName;
    public final Deferrability deferrability;

    public KeyMeta(ResultSet importedKey) {
        Validate.notNull((Object)importedKey);
        this.pkTableCat = ResultSetUtil.getValue(String.class, importedKey, "PKTABLE_CAT", null);
        this.pkTableSchem = ResultSetUtil.getValue(String.class, importedKey, "PKTABLE_SCHEM", null);
        this.pkTableName = ResultSetUtil.getValue(String.class, importedKey, "PKTABLE_NAME", null);
        this.pkColumnName = ResultSetUtil.getValue(String.class, importedKey, "PKCOLUMN_NAME", null);
        this.fkTableCat = ResultSetUtil.getValue(String.class, importedKey, "FKTABLE_CAT", null);
        this.fkTableSchem = ResultSetUtil.getValue(String.class, importedKey, "FKTABLE_SCHEM", null);
        this.fkTableName = ResultSetUtil.getValue(String.class, importedKey, "FKTABLE_NAME", null);
        this.fkColumnName = ResultSetUtil.getValue(String.class, importedKey, "FKCOLUMN_NAME", null);
        this.keySeq = ResultSetUtil.getValue(Short.TYPE, importedKey, "KEY_SEQ", Short.valueOf((short)0));
        this.updateRule = Rule.getRule(ResultSetUtil.getValue(Short.TYPE, importedKey, "UPDATE_RULE", Short.valueOf((short)0)));
        this.deleteRule = Rule.getRule(ResultSetUtil.getValue(Short.TYPE, importedKey, "DELETE_RULE", Short.valueOf((short)0)));
        this.fkName = ResultSetUtil.getValue(String.class, importedKey, "FK_NAME", null);
        this.pkName = ResultSetUtil.getValue(String.class, importedKey, "PK_NAME", null);
        this.deferrability = Deferrability.getDeferrability(ResultSetUtil.getValue(Short.TYPE, importedKey, "DEFERRABILITY", Short.valueOf((short)0)).shortValue());
        assert (this.pkTableName != null);
        assert (this.pkColumnName != null);
        assert (this.fkTableName != null);
        assert (this.fkColumnName != null);
        assert (this.updateRule != null);
        assert (this.deleteRule != null);
        assert (this.deferrability != null);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Rule {
        NO_ACTION(3),
        CASCADE(0),
        SET_NULL(2),
        SET_DEFAULT(4),
        RESTRICT(1);

        private final int value;

        private static Rule getRule(short value) {
            for (Rule rule : Rule.values()) {
                if (rule.value != value) continue;
                return rule;
            }
            return null;
        }

        private Rule(int value) {
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Deferrability {
        INITIALLY_DEFERRED(5),
        INITIALLY_IMMEDIATE(6),
        NOT_DEFERRABLE(7);

        private final int value;

        private static Deferrability getDeferrability(int value) {
            for (Deferrability deferrability : Deferrability.values()) {
                if (deferrability.value != value) continue;
                return deferrability;
            }
            return null;
        }

        private Deferrability(int value) {
            this.value = value;
        }
    }
}

