/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.Validate;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.utils.sql.SqlExecutorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class SqlExecutor {
    private static Logger logger = LoggerFactory.getLogger(SqlExecutor.class);
    static final char SINGLEQUOTE = '\'';
    static final char SEMICOLON = ';';
    static final char SPACE = ' ';
    final Connection connection;

    public SqlExecutor(Connection connection) {
        Validate.notNull((Object)connection);
        this.connection = connection;
    }

    public void execute(InputStream is) throws SQLException, IOException {
        this.execute(is, null);
    }

    public void execute(InputStream is, SqlExecutorHandler handler) throws SQLException, IOException {
        Validate.notNull((Object)is);
        this.execute(new InputStreamReader(is), handler);
    }

    public void execute(Reader in) throws SQLException, IOException {
        this.execute(in, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void execute(Reader in, SqlExecutorHandler handler) throws SQLException, IOException {
        Validate.notNull((Object)in);
        StringBuilder builder = new StringBuilder();
        boolean quotedFlag = false;
        boolean execFlag = false;
        int ch = in.read();
        while (true) {
            block9: {
                if (ch == -1) {
                    return;
                }
                switch (ch) {
                    case 39: {
                        quotedFlag = !quotedFlag;
                        break;
                    }
                    case 59: {
                        execFlag = !quotedFlag;
                        break;
                    }
                    case 32: {
                        if (builder.length() == 0) break block9;
                    }
                }
                if (execFlag) {
                    this.executeSingleSql(builder.toString(), handler);
                    builder.setLength(0);
                    execFlag = false;
                } else {
                    builder.append((char)ch);
                }
            }
            ch = in.read();
        }
    }

    public void execute(String sql) throws SQLException {
        this.execute(sql, null);
    }

    public void execute(String sql, SqlExecutorHandler handler) throws SQLException {
        Validate.notNull((Object)sql);
        try {
            this.execute(new StringReader(sql), handler);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeSingleSql(String sql, SqlExecutorHandler handler) throws SQLException {
        block9: {
            logger.info((Marker)LogMarker.DETAIL, sql);
            boolean isAutoCommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            Statement stmt = null;
            ResultSet rs = null;
            try {
                int count;
                stmt = this.connection.createStatement();
                if (stmt.execute(sql)) {
                    if (handler != null) {
                        rs = stmt.getResultSet();
                        handler.handleResultSet(sql, rs);
                    }
                } else if (handler != null && (count = stmt.getUpdateCount()) >= 0) {
                    handler.handleUpdateCount(sql, count);
                }
                this.connection.commit();
                this.connection.setAutoCommit(isAutoCommit);
            }
            catch (SQLException e) {
                this.connection.rollback();
                break block9;
            }
            finally {
                this.connection.setAutoCommit(isAutoCommit);
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly((Statement)stmt);
            }
            DbUtils.closeQuietly((ResultSet)rs);
            DbUtils.closeQuietly((Statement)stmt);
        }
    }
}

