/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jiemamy.dialect.AbstractDialect;
import org.jiemamy.dialect.DatabaseMetadataParser;
import org.jiemamy.dialect.DefaultDatabaseMetadataParser;
import org.jiemamy.dialect.DefaultSqlEmitter;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.Necessity;
import org.jiemamy.dialect.SqlEmitter;
import org.jiemamy.model.datatype.RawTypeCategory;
import org.jiemamy.model.datatype.RawTypeDescriptor;
import org.jiemamy.model.datatype.SimpleRawTypeDescriptor;
import org.jiemamy.model.datatype.TypeParameterKey;
import org.jiemamy.validator.StandardValidator;
import org.jiemamy.validator.Validator;

public final class GenericDialect
extends AbstractDialect {
    private static List<AbstractDialect.Entry> typeEntries = Lists.newArrayList();
    private Validator validator = new StandardValidator();

    public GenericDialect() {
        super("jdbc:", typeEntries);
    }

    public DatabaseMetadataParser getDatabaseMetadataParser() {
        return new DefaultDatabaseMetadataParser((Dialect)this);
    }

    public String getName() {
        return "Generic Dialect";
    }

    public SqlEmitter getSqlEmitter() {
        return new DefaultSqlEmitter((Dialect)this);
    }

    public Validator getValidator() {
        return this.validator;
    }

    static {
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.INTEGER), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SERIAL, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.DECIMAL), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.PRECISION, Necessity.REQUIRED);
                this.put(TypeParameterKey.SCALE, Necessity.REQUIRED);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.BOOLEAN)));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.VARCHAR), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.SIZE, Necessity.OPTIONAL);
            }
        }));
        typeEntries.add(new AbstractDialect.Entry((RawTypeDescriptor)new SimpleRawTypeDescriptor(RawTypeCategory.TIMESTAMP), (Map)new HashMap<TypeParameterKey<?>, Necessity>(){
            {
                this.put(TypeParameterKey.WITH_TIMEZONE, Necessity.OPTIONAL);
            }
        }));
    }
}

