/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.index;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.utils.CloneUtil;
import org.jiemamy.dddbase.utils.MutationMonitor;
import org.jiemamy.model.SimpleDbObject;
import org.jiemamy.model.index.JmIndex;
import org.jiemamy.model.index.JmIndexColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmIndex
extends SimpleDbObject
implements JmIndex {
    private boolean unique;
    private List<JmIndexColumn> indexColumns = Lists.newArrayList();

    public SimpleJmIndex() {
        this(UUID.randomUUID());
    }

    public SimpleJmIndex(UUID id) {
        super(id);
    }

    public void addIndexColumn(JmIndexColumn indexColumn) {
        Validate.notNull((Object)indexColumn);
        this.indexColumns.add(indexColumn);
    }

    @Override
    public SimpleJmIndex clone() {
        SimpleJmIndex clone = (SimpleJmIndex)super.clone();
        clone.indexColumns = CloneUtil.cloneValueArrayList(this.indexColumns);
        return clone;
    }

    @Override
    public List<JmIndexColumn> getIndexColumns() {
        assert (this.indexColumns != null);
        return MutationMonitor.monitor((List)Lists.newArrayList(this.indexColumns));
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    public void reomveIndexColumn(JmIndexColumn indexColumn) {
        Validate.notNull((Object)indexColumn);
        this.indexColumns.remove(indexColumn);
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public EntityRef<? extends SimpleJmIndex> toReference() {
        return new DefaultEntityRef((Entity)this);
    }
}

