/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.dataset;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.utils.MutationMonitor;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.dataset.JmRecord;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.script.ScriptString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmRecord
implements JmRecord {
    private final Map<EntityRef<? extends JmColumn>, ScriptString> values;

    public SimpleJmRecord(Map<EntityRef<? extends JmColumn>, ScriptString> values) {
        Validate.notNull(values);
        Validate.noNullElements(values.keySet());
        this.values = Maps.newHashMap(values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleJmRecord)) {
            return false;
        }
        SimpleJmRecord other = (SimpleJmRecord)obj;
        return ((Object)this.values).equals(other.values);
    }

    @Override
    public Map<EntityRef<? extends JmColumn>, ScriptString> getValues() {
        assert (this.values != null);
        return MutationMonitor.monitor((Map)Maps.newHashMap(this.values));
    }

    public int hashCode() {
        return ((Object)this.values).hashCode();
    }

    @Override
    public Iterable<Map.Entry<EntityRef<? extends JmColumn>, ScriptString>> toIterable(JiemamyContext context, EntityRef<? extends JmTable> tableRef) {
        Validate.notNull((Object)context);
        Validate.notNull(tableRef);
        JmTable table = context.resolve(tableRef);
        TreeMap sortedMap = Maps.newTreeMap((Comparator)new ColumnOrderComparator(table));
        sortedMap.putAll(this.values);
        return sortedMap.entrySet();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnOrderComparator
    implements Comparator<EntityRef<? extends JmColumn>> {
        private final JmTable table;

        private ColumnOrderComparator(JmTable table) {
            Validate.notNull((Object)table);
            this.table = table;
        }

        @Override
        public int compare(EntityRef<? extends JmColumn> o1, EntityRef<? extends JmColumn> o2) {
            int i1 = -1;
            int i2 = -1;
            List<JmColumn> columns = this.table.getColumns();
            for (JmColumn column : columns) {
                if (o1.isReferenceOf((Entity)column)) {
                    i1 = columns.indexOf(column);
                }
                if (!o2.isReferenceOf((Entity)column)) continue;
                i2 = columns.indexOf(column);
            }
            if (i1 == -1 && i2 == -1) {
                return o1.getReferentId().compareTo(o2.getReferentId());
            }
            return i1 - i2;
        }
    }
}

