/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.seasar.dao.DaoAnnotationReader;
import org.seasar.dao.NullBean;
import org.seasar.dao.util.TypeUtil;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.StringUtil;

public class FieldDaoAnnotationReader
implements DaoAnnotationReader {
    public String BEAN = "BEAN";
    public String BEAN_SUFFIX = "_BEAN";
    public String PROCEDURE_SUFFIX = "_PROCEDURE";
    public String PROCEDURE_CALL_SUFFIX = "_PROCEDURE_CALL";
    public String ARGS_SUFFIX = "_ARGS";
    public String SQL_SUFFIX = "_SQL";
    public String QUERY_SUFFIX = "_QUERY";
    public String NO_PERSISTENT_PROPS_SUFFIX = "_NO_PERSISTENT_PROPS";
    public String PERSISTENT_PROPS_SUFFIX = "_PERSISTENT_PROPS";
    public String SQL_FILE_SUFFIX = "_SQL_FILE";
    public String CHECK_SINGLE_ROW_UPDATE = "CHECK_SINGLE_ROW_UPDATE";
    public String CHECK_SINGLE_ROW_UPDATE_SUFFIX = "_CHECK_SINGLE_ROW_UPDATE";
    protected BeanDesc daoBeanDesc;

    public FieldDaoAnnotationReader(BeanDesc daoBeanDesc) {
        this.daoBeanDesc = daoBeanDesc;
    }

    public String[] getArgNames(Method method) {
        String argsKey = method.getName() + this.ARGS_SUFFIX;
        if (this.daoBeanDesc.hasField(argsKey)) {
            Field argNamesField = this.daoBeanDesc.getField(argsKey);
            String argNames = (String)FieldUtil.get((Field)argNamesField, null);
            return StringUtil.split((String)argNames, (String)" ,");
        }
        return new String[0];
    }

    public String getQuery(Method method) {
        String key = method.getName() + this.QUERY_SUFFIX;
        if (this.daoBeanDesc.hasField(key)) {
            Field queryField = this.daoBeanDesc.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        return null;
    }

    public String getStoredProcedureName(Method method) {
        String key = method.getName() + this.PROCEDURE_SUFFIX;
        if (this.daoBeanDesc.hasField(key)) {
            Field queryField = this.daoBeanDesc.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        return null;
    }

    public String getProcedureCallName(Method method) {
        String key = method.getName() + this.PROCEDURE_CALL_SUFFIX;
        if (this.daoBeanDesc.hasField(key)) {
            Field queryField = this.daoBeanDesc.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        return null;
    }

    public Class getBeanClass() {
        if (this.daoBeanDesc.hasField(this.BEAN)) {
            Field beanField = this.daoBeanDesc.getField(this.BEAN);
            return (Class)FieldUtil.get((Field)beanField, null);
        }
        return NullBean.class;
    }

    public Class getBeanClass(Method method) {
        String fieldName = method.getName() + this.BEAN_SUFFIX;
        if (this.daoBeanDesc.hasField(fieldName)) {
            Field field = this.daoBeanDesc.getField(fieldName);
            return (Class)FieldUtil.get((Field)field, null);
        }
        if (List.class.isAssignableFrom(method.getReturnType())) {
            return null;
        }
        if (TypeUtil.isSimpleType(method.getReturnType())) {
            return method.getReturnType();
        }
        if (method.getReturnType().isArray()) {
            return method.getReturnType().getComponentType();
        }
        return method.getReturnType();
    }

    public String[] getNoPersistentProps(Method method) {
        return this.getProps(method, method.getName() + this.NO_PERSISTENT_PROPS_SUFFIX);
    }

    public String[] getPersistentProps(Method method) {
        return this.getProps(method, method.getName() + this.PERSISTENT_PROPS_SUFFIX);
    }

    private String[] getProps(Method method, String fieldName) {
        if (this.daoBeanDesc.hasField(fieldName)) {
            Field field = this.daoBeanDesc.getField(fieldName);
            String s = (String)FieldUtil.get((Field)field, null);
            return StringUtil.split((String)s, (String)", ");
        }
        return null;
    }

    public String getSQL(Method method, String dbmsSuffix) {
        String key = method.getName() + dbmsSuffix + this.SQL_SUFFIX;
        if (this.daoBeanDesc.hasField(key)) {
            Field queryField = this.daoBeanDesc.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        key = method.getName() + this.SQL_SUFFIX;
        if (this.daoBeanDesc.hasField(key)) {
            Field queryField = this.daoBeanDesc.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        return null;
    }

    public boolean isSqlFile(Method method) {
        String fieldName = method.getName() + this.SQL_FILE_SUFFIX;
        return this.daoBeanDesc.hasField(fieldName);
    }

    public String getSqlFilePath(Method method) {
        Field field;
        Object obj;
        String fieldName = method.getName() + this.SQL_FILE_SUFFIX;
        if (this.daoBeanDesc.hasField(fieldName) && (obj = FieldUtil.get((Field)(field = this.daoBeanDesc.getField(fieldName)), null)) instanceof String) {
            return (String)obj;
        }
        return "";
    }

    public boolean isCheckSingleRowUpdate() {
        return this.getSingleRowUpdateCheckValue(this.CHECK_SINGLE_ROW_UPDATE);
    }

    public boolean isCheckSingleRowUpdate(Method method) {
        String fieldName = method.getName() + this.CHECK_SINGLE_ROW_UPDATE_SUFFIX;
        return this.getSingleRowUpdateCheckValue(fieldName);
    }

    private boolean getSingleRowUpdateCheckValue(String fieldName) {
        Field field;
        Object obj;
        if (this.daoBeanDesc.hasField(fieldName) && (obj = FieldUtil.get((Field)(field = this.daoBeanDesc.getField(fieldName)), null)) instanceof Boolean) {
            return (Boolean)obj;
        }
        return true;
    }
}

