/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.entity;


/**
 * テーブルBuriStateとマッピング関係にあるテーブルに対応するDtoです。
 * @author S2Dao-CodeGen
 */
public abstract class AbstractBuriStateRelation extends AbstractBuriState {

	private BuriData data;
	
	private BuriPath path;
	
	private BuriBranch branch;
	

	/**
	 * BuriDataに対応するEntityを返します。
	 * @return BuriDataに対応するEntity
	 */
	@org.seasar.dao.annotation.tiger.Relation(relationKey = "DataID:DataID", relationNo = 0)
	public BuriData getData() {
		return this.data;
	}

	/**
	 * BuriDataに対応するDtoを設定します。
	 * @param data BuriDataに対応するEntity
	 */
	public void setData(BuriData data) {
		this.data = data;
	}
	/**
	 * BuriPathに対応するEntityを返します。
	 * @return BuriPathに対応するEntity
	 */
	@org.seasar.dao.annotation.tiger.Relation(relationKey = "PathID:PathID", relationNo = 1)
	public BuriPath getPath() {
		return this.path;
	}

	/**
	 * BuriPathに対応するDtoを設定します。
	 * @param path BuriPathに対応するEntity
	 */
	public void setPath(BuriPath path) {
		this.path = path;
	}
	/**
	 * BuriBranchに対応するEntityを返します。
	 * @return BuriBranchに対応するEntity
	 */
	@org.seasar.dao.annotation.tiger.Relation(relationKey = "BranchID:BranchID", relationNo = 2)
	public BuriBranch getBranch() {
		return this.branch;
	}

	/**
	 * BuriBranchに対応するDtoを設定します。
	 * @param branch BuriBranchに対応するEntity
	 */
	public void setBranch(BuriBranch branch) {
		this.branch = branch;
	}

	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append(super.toString());
		buf.append("data").append(data);
		buf.append("path").append(path);
		buf.append("branch").append(branch);
		return buf.toString();
	}

}
