/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * BuriPathテーブルのEntityです。
 * @author S2Dao-CodeGen
 */


public abstract class AbstractBuriPath {

	private Long pathID;
	private String pathName = "";
	private String realPathName = "";
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * PathIDを返します。
	 * @return PathID
	 */
	@org.seasar.dao.annotation.tiger.Id(value=org.seasar.dao.annotation.tiger.IdType.ASSIGNED)
	@org.seasar.dao.annotation.tiger.Column("PathID")
	public Long getPathID() {
		return pathID;
	}

	/**
	 * PathIDを設定します。
	 * @param pathID PathID
	 */
	public void setPathID(Long pathID) {
		modifiedPropertySet.add("pathID");
		this.pathID = pathID;
	}

	/**
	 * PathNameを返します。
	 * @return PathName
	 */
	@org.seasar.dao.annotation.tiger.Column("PathName")
	public String getPathName() {
		return pathName;
	}

	/**
	 * PathNameを設定します。
	 * @param pathName PathName
	 */
	public void setPathName(String pathName) {
		modifiedPropertySet.add("pathName");
		this.pathName = pathName;
	}

	/**
	 * RealPathNameを返します。
	 * @return RealPathName
	 */
	@org.seasar.dao.annotation.tiger.Column("RealPathName")
	public String getRealPathName() {
		return realPathName;
	}

	/**
	 * RealPathNameを設定します。
	 * @param realPathName RealPathName
	 */
	public void setRealPathName(String realPathName) {
		modifiedPropertySet.add("realPathName");
		this.realPathName = realPathName;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/pathID=").append(pathID);
		buff.append("/pathName=").append(pathName);
		buff.append("/realPathName=").append(realPathName);
		buff.append("]");
		return buff.toString();
	}

}
