/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.script;

import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.ServiceLocator;
import org.jiemamy.script.PlainScriptEngine;
import org.jiemamy.script.ScriptEngine;
import org.jiemamy.script.ScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptString {
    private static final String DEFAULT_ENGINE = PlainScriptEngine.class.getName();
    private final String script;
    private final String scriptEngineClassName;
    private ScriptEngine scriptEngine;

    public ScriptString(String script) {
        this(script, DEFAULT_ENGINE);
    }

    public ScriptString(String script, Class<? extends ScriptEngine> scriptEngineClass) {
        this(script, scriptEngineClass.getName());
    }

    public ScriptString(String script, String scriptEngineClassName) {
        Validate.notNull((Object)scriptEngineClassName);
        this.script = script;
        this.scriptEngineClassName = scriptEngineClassName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptString other = (ScriptString)obj;
        if (this.script == null ? other.script != null : !this.script.equals(other.script)) {
            return false;
        }
        return this.scriptEngineClassName.equals(other.scriptEngineClassName);
    }

    public String getScript() {
        return this.script;
    }

    public String getScriptEngineClassName() {
        return this.scriptEngineClassName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
        result = 31 * result + this.scriptEngineClassName.hashCode();
        return result;
    }

    public String process(Map<String, Object> env) throws ClassNotFoundException, ScriptException {
        if (this.scriptEngine == null) {
            ServiceLocator serviceLocator = JiemamyContext.getServiceLocator();
            this.scriptEngine = serviceLocator.getService(ScriptEngine.class, this.scriptEngineClassName);
        }
        return this.scriptEngine.process(env, this.script);
    }

    public String toString() {
        return this.script;
    }
}

