/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.staxmate.out;

import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.staxmate.out.SMBufferedFragment;
import org.codehaus.staxmate.out.SMGlobalNamespace;
import org.codehaus.staxmate.out.SMLocalNamespace;
import org.codehaus.staxmate.out.SMNamespace;
import org.codehaus.staxmate.out.SMOAttribute;
import org.codehaus.staxmate.out.SMOCData;
import org.codehaus.staxmate.out.SMOCharacters;
import org.codehaus.staxmate.out.SMOComment;
import org.codehaus.staxmate.out.SMOEntityRef;
import org.codehaus.staxmate.out.SMONamespace;
import org.codehaus.staxmate.out.SMOProcInstr;
import org.codehaus.staxmate.out.SMOTypedValue;
import org.codehaus.staxmate.out.SMOutputDocument;
import org.codehaus.staxmate.out.SMOutputtable;
import org.codehaus.staxmate.out.SMRootFragment;

public final class SMOutputContext {
    static final int DEF_NS_STACK_SIZE = 16;
    protected static final SMNamespace NS_EMPTY = new SMGlobalNamespace("", "");
    protected static final SMNamespace NS_XML = new SMGlobalNamespace("xml", "http://www.w3.org/XML/1998/namespace");
    protected static final SMNamespace NS_XMLNS = new SMGlobalNamespace("xmlns", "http://www.w3.org/2000/xmlns/");
    static final HashMap<String, SMNamespace> sGlobalNsMap = new HashMap();
    static final SMOTypedValue FALSE_VALUE;
    static final SMOTypedValue TRUE_VALUE;
    final XMLStreamWriter2 _streamWriter;
    final NamespaceContext _rootNsContext;
    final boolean _cfgRepairing;
    String _nsPrefixPrefix = "ns";
    int _nsPrefixSeqNr = 1;
    boolean _cfgPreferDefaultNs = false;
    HashMap<String, SMNamespace> _localNsMap = null;
    SMNamespace _defaultNS = NS_EMPTY;
    SMNamespace[] _nsStack = null;
    int _boundNsCount = 0;
    SMNamespace _currElemNS;
    String _indentString = null;
    int _indentOffset = 0;
    int _indentStep = 0;
    int _indentSuppress = -1;
    boolean _indentLevelEmpty = true;

    protected SMOutputContext(XMLStreamWriter2 sw, NamespaceContext rootNsCtxt) {
        this._streamWriter = sw;
        this._rootNsContext = rootNsCtxt;
        Object o = sw.getProperty("javax.xml.stream.isRepairingNamespaces");
        this._cfgRepairing = o instanceof Boolean && (Boolean)o != false;
    }

    public void setIndentation(String indentStr, int startOffset, int step) {
        this._indentString = indentStr;
        this._indentOffset = startOffset;
        this._indentStep = step;
        this._indentSuppress = 0;
    }

    public static SMOutputContext createInstance(XMLStreamWriter2 sw, NamespaceContext rootNsCtxt) throws XMLStreamException {
        return new SMOutputContext(sw, rootNsCtxt);
    }

    public static SMOutputContext createInstance(XMLStreamWriter2 sw) throws XMLStreamException {
        return SMOutputContext.createInstance(sw, sw.getNamespaceContext());
    }

    public SMOutputDocument createDocument() throws XMLStreamException {
        return new SMOutputDocument(this);
    }

    public SMOutputDocument createDocument(String version, String encoding) throws XMLStreamException {
        return new SMOutputDocument(this, version, encoding);
    }

    public SMOutputDocument createDocument(String version, String encoding, boolean standalone) throws XMLStreamException {
        return new SMOutputDocument(this, version, encoding, standalone);
    }

    public SMRootFragment createRootFragment() throws XMLStreamException {
        return new SMRootFragment(this);
    }

    public SMBufferedFragment createBufferedFragment() throws XMLStreamException {
        return new SMBufferedFragment(this);
    }

    public SMOutputtable createAttribute(SMNamespace ns, String localName, String value) {
        return new SMOAttribute(ns, localName, value);
    }

    public SMOutputtable createNamespace(SMNamespace ns, SMNamespace parentDefaultNS, int parentNsCount) {
        return new SMONamespace(ns, parentDefaultNS, parentNsCount);
    }

    public SMOutputtable createCharacters(String text) {
        return SMOCharacters.create(text);
    }

    public SMOutputtable createCharacters(char[] buf, int offset, int len) {
        return SMOCharacters.createShared(buf, offset, len);
    }

    public SMOutputtable createNonSharedCharacters(char[] buf, int offset, int len) {
        return SMOCharacters.createNonShared(buf, offset, len);
    }

    public SMOutputtable createCData(String text) {
        return SMOCData.create(text);
    }

    public SMOutputtable createCData(char[] buf, int offset, int len) {
        return SMOCData.createShared(buf, offset, len);
    }

    public SMOutputtable createNonSharedCData(char[] buf, int offset, int len) {
        return SMOCData.createNonShared(buf, offset, len);
    }

    public SMOutputtable createComment(String text) {
        return new SMOComment(text);
    }

    public SMOutputtable createEntityRef(String name) {
        return new SMOEntityRef(name);
    }

    public SMOutputtable createProcessingInstruction(String target, String data) {
        return new SMOProcInstr(target, data);
    }

    public SMOutputtable createValue(boolean value) {
        return value ? TRUE_VALUE : FALSE_VALUE;
    }

    public SMOutputtable createValue(int value) {
        return SMOTypedValue.create(value);
    }

    public SMOutputtable createValue(long value) {
        return SMOTypedValue.create(value);
    }

    public SMOutputtable createValue(double value) {
        return SMOTypedValue.create(value);
    }

    public final SMNamespace getNamespace(String uri) {
        SMNamespace ns;
        if (uri == null || uri.length() == 0) {
            return NS_EMPTY;
        }
        if (this._localNsMap != null && (ns = this._localNsMap.get(uri)) != null) {
            return ns;
        }
        ns = sGlobalNsMap.get(uri);
        if (ns == null) {
            ns = new SMLocalNamespace(this, uri, this._cfgPreferDefaultNs, null);
            if (this._localNsMap == null) {
                this._localNsMap = new HashMap();
            }
            this._localNsMap.put(uri, ns);
        }
        return ns;
    }

    public final SMNamespace getNamespace(String uri, String prefPrefix) {
        SMNamespace ns;
        if (uri == null || uri.length() == 0) {
            return NS_EMPTY;
        }
        if (this._localNsMap != null && (ns = this._localNsMap.get(uri)) != null) {
            return ns;
        }
        ns = sGlobalNsMap.get(uri);
        if (ns == null) {
            ns = new SMLocalNamespace(this, uri, this._cfgPreferDefaultNs, prefPrefix);
            if (this._localNsMap == null) {
                this._localNsMap = new HashMap();
            }
            this._localNsMap.put(uri, ns);
        }
        return ns;
    }

    public static final SMNamespace getEmptyNamespace() {
        return NS_EMPTY;
    }

    public final XMLStreamWriter2 getWriter() {
        return this._streamWriter;
    }

    public final boolean isWriterRepairing() {
        return this._cfgRepairing;
    }

    public void writeCharacters(String text) throws XMLStreamException {
        if (this._indentSuppress == 0) {
            this._indentSuppress = 1;
        }
        this._streamWriter.writeCharacters(text);
    }

    public void writeCharacters(char[] buf, int offset, int len) throws XMLStreamException {
        if (this._indentSuppress == 0) {
            this._indentSuppress = 1;
        }
        this._streamWriter.writeCharacters(buf, offset, len);
    }

    public void writeCData(String text) throws XMLStreamException {
        if (this._indentSuppress == 0) {
            this._indentSuppress = 1;
        }
        this._streamWriter.writeCData(text);
    }

    public void writeCData(char[] buf, int offset, int len) throws XMLStreamException {
        if (this._indentSuppress == 0) {
            this._indentSuppress = 1;
        }
        this._streamWriter.writeCData(buf, offset, len);
    }

    public void writeComment(String text) throws XMLStreamException {
        if (this._indentSuppress == 0) {
            this.outputIndentation();
            this._indentLevelEmpty = false;
        }
        this._streamWriter.writeComment(text);
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        if (this._indentSuppress == 0) {
            this._indentSuppress = 1;
        }
        this._streamWriter.writeEntityRef(name);
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        if (this._indentSuppress == 0) {
            this.outputIndentation();
            this._indentLevelEmpty = false;
        }
        if (data == null) {
            this._streamWriter.writeProcessingInstruction(target);
        } else {
            this._streamWriter.writeProcessingInstruction(target, data);
        }
    }

    public void writeAttribute(SMNamespace ns, String localName, String value) throws XMLStreamException {
        if (this._cfgRepairing) {
            String prefix = ns.getPreferredPrefix();
            if (prefix == null) {
                this._streamWriter.writeAttribute(ns.getURI(), localName, value);
            } else {
                this._streamWriter.writeAttribute(prefix, ns.getURI(), localName, value);
            }
            return;
        }
        if (ns == NS_EMPTY) {
            this._streamWriter.writeAttribute(localName, value);
            return;
        }
        String prefix = ns.getBoundPrefix();
        if (prefix == null || prefix.length() == 0) {
            prefix = this.findRootPrefix(ns);
            if (prefix != null) {
                ns._bindPermanentlyAs(prefix);
            } else {
                prefix = ns.getLastBoundPrefix();
                if (prefix == null) {
                    prefix = ns.getPreferredPrefix();
                }
                if (prefix == null || this.isPrefixBound(prefix)) {
                    prefix = this.generateUnboundPrefix();
                }
                this.bindAndWriteNs(ns, prefix);
            }
        }
        this._streamWriter.writeAttribute(prefix, ns.getURI(), localName, value);
    }

    public void predeclareNamespace(SMNamespace ns, SMNamespace parentDefaultNS, int parentNsCount) throws XMLStreamException {
        String prefix = ns.getPreferredPrefix();
        if (this._cfgRepairing) {
            if (prefix == null) {
                this._streamWriter.writeDefaultNamespace(ns.getURI());
            } else {
                this._streamWriter.writeNamespace(prefix, ns.getURI());
            }
            return;
        }
        if (prefix == null) {
            if (this._defaultNS == parentDefaultNS && this._currElemNS != null && this._currElemNS.isBoundToPrefix()) {
                this._defaultNS = ns;
                this._streamWriter.writeDefaultNamespace(ns.getURI());
            }
        } else if (!this.isPrefixBoundLocally(prefix, parentNsCount)) {
            this.bindAndWriteNs(ns, prefix);
        }
    }

    public SMNamespace writeStartElement(SMNamespace ns, String localName) throws XMLStreamException {
        String prefix;
        if (this._indentSuppress >= 0) {
            if (this._indentSuppress == 0) {
                this.outputIndentation();
                this._indentOffset += this._indentStep;
            } else {
                ++this._indentSuppress;
            }
            this._indentLevelEmpty = true;
        }
        this._currElemNS = ns;
        if (this._cfgRepairing) {
            String prefix2 = ns.getPreferredPrefix();
            if (prefix2 == null) {
                this._streamWriter.writeStartElement(ns.getURI(), localName);
            } else {
                this._streamWriter.writeStartElement(prefix2, localName, ns.getURI());
            }
            return this._defaultNS;
        }
        SMNamespace oldDefaultNs = this._defaultNS;
        boolean needToBind = false;
        if (ns == oldDefaultNs) {
            prefix = "";
        } else {
            prefix = ns.getBoundPrefix();
            if (prefix != null) {
                if (ns == NS_EMPTY) {
                    needToBind = true;
                }
            } else {
                prefix = this.findRootPrefix(ns);
                if (prefix != null) {
                    ns._bindPermanentlyAs(prefix);
                } else {
                    needToBind = true;
                    if (ns.prefersDefaultNs()) {
                        prefix = "";
                    } else {
                        prefix = ns.getLastBoundPrefix();
                        if ((prefix == null || this.isPrefixBound(prefix)) && ((prefix = ns.getPreferredPrefix()) == null || this.isPrefixBound(prefix))) {
                            prefix = "";
                        }
                    }
                }
            }
        }
        this._streamWriter.writeStartElement(prefix, localName, ns.getURI());
        if (needToBind) {
            if (prefix.length() == 0) {
                this._defaultNS = ns;
                this._streamWriter.writeDefaultNamespace(ns.getURI());
            } else {
                this.bindAndWriteNs(ns, prefix);
            }
        }
        return oldDefaultNs;
    }

    public void writeEndElement(int parentNsCount, SMNamespace parentDefNs) throws XMLStreamException {
        if (this._indentSuppress >= 0) {
            this._indentOffset -= this._indentStep;
            if (this._indentSuppress == 0) {
                if (!this._indentLevelEmpty) {
                    this.outputIndentation();
                }
            } else {
                --this._indentSuppress;
            }
            this._indentLevelEmpty = false;
        }
        this._streamWriter.writeEndElement();
        if (!this._cfgRepairing && this._boundNsCount > parentNsCount) {
            int i = this._boundNsCount;
            this._boundNsCount = parentNsCount;
            while (i-- > parentNsCount) {
                SMNamespace ns = this._nsStack[i];
                this._nsStack[i] = null;
                ns._unbind();
            }
        }
        this._defaultNS = parentDefNs;
    }

    public void writeStartDocument() throws XMLStreamException {
        this._streamWriter.writeStartDocument();
    }

    public void writeStartDocument(String version, String encoding) throws XMLStreamException {
        this._streamWriter.writeStartDocument(encoding, version);
    }

    public void writeStartDocument(String version, String encoding, boolean standalone) throws XMLStreamException {
        this._streamWriter.writeStartDocument(version, encoding, standalone);
    }

    public void writeEndDocument() throws XMLStreamException {
        this._streamWriter.writeEndDocument();
        this._streamWriter.close();
    }

    public void writeDoctypeDecl(String rootName, String systemId, String publicId, String intSubset) throws XMLStreamException {
        if (this._indentSuppress == 0) {
            this.outputIndentation();
        }
        this._streamWriter.writeDTD(rootName, systemId, publicId, intSubset);
    }

    public void writeValue(boolean v) throws XMLStreamException {
        this._streamWriter.writeBoolean(v);
    }

    public void writeValue(int v) throws XMLStreamException {
        this._streamWriter.writeInt(v);
    }

    public void writeValue(long v) throws XMLStreamException {
        this._streamWriter.writeLong(v);
    }

    public void writeValue(double d) throws XMLStreamException {
        this._streamWriter.writeDouble(d);
    }

    public void flushWriter() throws XMLStreamException {
        this._streamWriter.flush();
    }

    public void closeWriterCompletely() throws XMLStreamException {
        this._streamWriter.closeCompletely();
    }

    public String generateUnboundPrefix() {
        String prefix;
        while (this.isPrefixBound(prefix = this._nsPrefixPrefix + this._nsPrefixSeqNr++)) {
        }
        return prefix;
    }

    public boolean isPrefixBound(String prefix) {
        String uri;
        int i = this._boundNsCount;
        while (--i >= 0) {
            SMNamespace ns = this._nsStack[i];
            if (!prefix.equals(ns.getBoundPrefix())) continue;
            return true;
        }
        return this._rootNsContext != null && (uri = this._rootNsContext.getNamespaceURI(prefix)) != null && uri.length() > 0;
    }

    public boolean isPrefixBoundLocally(String prefix, int parentNsCount) {
        for (int i = parentNsCount; i < this._boundNsCount; ++i) {
            SMNamespace ns = this._nsStack[i];
            if (!prefix.equals(ns.getBoundPrefix())) continue;
            return true;
        }
        return false;
    }

    public String findRootPrefix(SMNamespace ns) {
        String uri;
        String prefix;
        if (this._rootNsContext != null && (prefix = this._rootNsContext.getPrefix(uri = ns.getURI())) != null && prefix.length() > 0) {
            return prefix;
        }
        return null;
    }

    int getNamespaceCount() {
        return this._boundNsCount;
    }

    boolean isDefaultNs(SMNamespace ns) {
        return this._defaultNS == ns;
    }

    private void bindAndWriteNs(SMNamespace ns, String prefix) throws XMLStreamException {
        SMNamespace[] stack = this._nsStack;
        if (stack == null) {
            this._nsStack = stack = new SMNamespace[16];
        } else if (this._boundNsCount >= stack.length) {
            this._nsStack = new SMNamespace[stack.length * 2];
            System.arraycopy(stack, 0, this._nsStack, 0, stack.length);
            stack = this._nsStack;
        }
        stack[this._boundNsCount++] = ns;
        ns._bindAs(prefix);
        this._streamWriter.writeNamespace(prefix, ns.getURI());
    }

    private void outputIndentation() throws XMLStreamException {
        int offset = this._indentOffset;
        if (offset > 0) {
            int len = this._indentString.length();
            if (offset > len) {
                offset = len;
            }
            String ind = this._indentString.substring(0, offset);
            this._streamWriter.writeRaw(ind);
        }
    }

    static {
        sGlobalNsMap.put(NS_EMPTY.getURI(), NS_EMPTY);
        sGlobalNsMap.put(NS_XML.getURI(), NS_XML);
        sGlobalNsMap.put(NS_XMLNS.getURI(), NS_XMLNS);
        FALSE_VALUE = SMOTypedValue.create(false);
        TRUE_VALUE = SMOTypedValue.create(true);
    }
}

