/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.buri.engine;

import java.util.ArrayList;
import java.util.List;
import org.seasar.buri.engine.BuriRealPath;
import org.seasar.buri.oouo.internal.structure.BuriActivityType;
import org.seasar.buri.oouo.internal.structure.BuriPackageType;
import org.seasar.buri.oouo.internal.structure.BuriWorkflowProcessType;

public class BuriPath {
    private long buriPathID = 0L;
    private BuriRealPath thisPath = new BuriRealPath();
    private BuriRealPath realPath = new BuriRealPath();
    private Long pathType;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BuriPath() {
        this("");
    }

    public BuriPath(String path) {
        this.thisPath = new BuriRealPath(path);
    }

    public BuriPath(String path, String realStrPath) {
        this.thisPath = new BuriRealPath(path);
        this.realPath = new BuriRealPath(realStrPath);
    }

    public BuriPath(String path, String realStrPath, long pathID) {
        this.thisPath = new BuriRealPath(path);
        this.realPath = new BuriRealPath(realStrPath);
        this.buriPathID = pathID;
    }

    public BuriPath(String path, String realStrPath, long pathID, Long pathType) {
        this.thisPath = new BuriRealPath(path);
        this.realPath = new BuriRealPath(realStrPath);
        this.buriPathID = pathID;
        this.pathType = pathType;
    }

    public BuriPath(String path, String realStrPath, Long pathType) {
        this.thisPath = new BuriRealPath(path);
        this.realPath = new BuriRealPath(realStrPath);
        this.pathType = pathType;
    }

    public BuriPath copy() {
        BuriPath clonePath = new BuriPath();
        clonePath.thisPath = this.thisPath.copyRealPath();
        clonePath.realPath = this.realPath.copyRealPath();
        clonePath.buriPathID = this.buriPathID;
        clonePath.pathType = this.pathType;
        return clonePath;
    }

    public Long getPathType() {
        return this.pathType;
    }

    public BuriPath setPathType(Long pathType) {
        BuriPath clonePath = this.copy();
        clonePath.pathType = pathType;
        return clonePath;
    }

    public BuriPath moveChildPath(String newPath, String newRealPath) {
        BuriPath clonePath = this.copy();
        clonePath = clonePath.setBuriPathID(0L);
        clonePath.thisPath.moveChildPath(newPath);
        clonePath.realPath.moveChildPath(newRealPath);
        return clonePath;
    }

    public BuriPath moveChildPath(BuriActivityType newAct) {
        BuriPath clonePath = this.moveChildPath(newAct.getName(), newAct.getId());
        return clonePath;
    }

    public BuriPath moveUpPath() {
        BuriPath clonePath = this.copy();
        clonePath = clonePath.setBuriPathID(0L);
        clonePath.thisPath.moveUpPath();
        clonePath.realPath.moveUpPath();
        return clonePath;
    }

    public List getActivityName() {
        return new ArrayList(this.thisPath.getActivity());
    }

    public List getActivityId() {
        return new ArrayList(this.realPath.getActivity());
    }

    public String getWorkflowProcess() {
        return this.thisPath.getWorkflowProcess();
    }

    public BuriPath setWorkflowProcess(String process) {
        BuriPath clonePath = this.copy();
        clonePath.thisPath.setWorkflowProcess(process);
        if (!$assertionsDisabled && this.realPath.getWorkflowProcess().length() != 0) {
            throw new AssertionError((Object)"realPath\u3092\u8a2d\u5b9a\u3057\u3066\u3044\u308b\u306e\u306b\u8ad6\u7406\u30d1\u30b9\u3060\u3051\u8a2d\u5b9a");
        }
        return clonePath;
    }

    public BuriPath setWorkflowProcess(String process, String realProcess) {
        BuriPath clonePath = this.copy();
        clonePath.thisPath.setWorkflowProcess(process);
        clonePath.realPath.setWorkflowProcess(realProcess);
        return clonePath;
    }

    public BuriPath setWorkflowProcess(BuriWorkflowProcessType wkfProcess) {
        BuriPath clonePath = this.copy();
        clonePath.thisPath.setWorkflowProcess(wkfProcess);
        clonePath.realPath.setWorkflowProcess(wkfProcess.getId());
        return clonePath;
    }

    public String getWorkflowPackage() {
        return this.thisPath.getWorkflowPackage();
    }

    public BuriPath setWorkflowPackage(String workflow) {
        BuriPath clonePath = this.copy();
        clonePath.thisPath.setWorkflowPackage(workflow);
        if (!$assertionsDisabled && this.realPath.getWorkflowPackage().length() != 0) {
            throw new AssertionError((Object)"realPath\u3092\u8a2d\u5b9a\u3057\u3066\u3044\u308b\u306e\u306b\u8ad6\u7406\u30d1\u30b9\u3060\u3051\u8a2d\u5b9a");
        }
        return clonePath;
    }

    public BuriPath setWorkflowPackage(String workflow, String realWorkflow) {
        BuriPath clonePath = this.copy();
        clonePath.thisPath.setWorkflowPackage(workflow);
        clonePath.realPath.setWorkflowPackage(realWorkflow);
        return clonePath;
    }

    public BuriPath setWorkflowPackage(BuriPackageType packageDoc) {
        BuriPath clonePath = this.copy();
        clonePath.thisPath.setWorkflowPackage(packageDoc.getName());
        clonePath.realPath.setWorkflowPackage(packageDoc.getId());
        return clonePath;
    }

    public String toString() {
        String str = this.thisPath.getPlainName();
        str = str + "[" + this.realPath.getPlainName() + "]";
        return str;
    }

    public BuriRealPath getRealPath() {
        return this.realPath;
    }

    public String getPlainName() {
        return this.thisPath.getPlainName();
    }

    public long getBuriPathID() {
        return this.buriPathID;
    }

    public BuriPath setBuriPathID(long buriPathID) {
        BuriPath clonePath = this.copy();
        clonePath.buriPathID = buriPathID;
        return clonePath;
    }

    public boolean isCorrect() {
        if (this.getBuriPathID() != 0L) {
            return true;
        }
        return this.getRealPath().isCorrect();
    }

    public boolean equals(Object obj) {
        BuriPath tgtPath;
        return obj instanceof BuriPath && (tgtPath = (BuriPath)obj).getBuriPathID() != 0L && this.getBuriPathID() != 0L && tgtPath.getBuriPathID() == this.getBuriPathID();
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (int)(this.buriPathID ^ this.buriPathID >>> 32);
        hashCode = 31 * hashCode + (this.thisPath == null ? 0 : this.thisPath.hashCode());
        hashCode = 31 * hashCode + (this.realPath == null ? 0 : this.realPath.hashCode());
        return hashCode;
    }

    static {
        $assertionsDisabled = !BuriPath.class.desiredAssertionStatus();
    }
}

