/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResultSetUtil {
    public static InputStream getAsciiStream(ResultSet rs, int columnIndex, InputStream defaultValue) {
        Validate.notNull((Object)rs);
        try {
            return rs.getAsciiStream(columnIndex);
        }
        catch (SQLException sQLException) {
            return defaultValue;
        }
    }

    public static InputStream getAsciiStream(ResultSet rs, String columnName, InputStream defaultValue) {
        Validate.notNull((Object)rs);
        try {
            return rs.getAsciiStream(columnName);
        }
        catch (SQLException sQLException) {
            return defaultValue;
        }
    }

    public static InputStream getBinaryStream(ResultSet rs, int columnIndex, InputStream defaultValue) {
        Validate.notNull((Object)rs);
        try {
            return rs.getBinaryStream(columnIndex);
        }
        catch (SQLException sQLException) {
            return defaultValue;
        }
    }

    public static InputStream getBinaryStream(ResultSet rs, String columnName, InputStream defaultValue) {
        Validate.notNull((Object)rs);
        try {
            return rs.getBinaryStream(columnName);
        }
        catch (SQLException sQLException) {
            return defaultValue;
        }
    }

    public static <T> T getValue(Class<T> returnType, ResultSet rs, int columnIndex, T defaultValue) {
        Validate.notNull(returnType);
        Validate.notNull((Object)rs);
        return ResultSetUtil.getValueInternal(returnType, rs, Integer.TYPE, new Object[]{columnIndex}, defaultValue);
    }

    public static <T> T getValue(Class<T> returnType, ResultSet rs, String columnName, T defaultValue) {
        Validate.notNull(returnType);
        Validate.notNull((Object)rs);
        Validate.notNull((Object)columnName);
        return ResultSetUtil.getValueInternal(returnType, rs, String.class, new Object[]{columnName}, defaultValue);
    }

    private static Method findMethod(Class<?> returnType, Class<?> parameterType) {
        for (Method method : ResultSet.class.getMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].equals(parameterType) || !returnType.equals(method.getReturnType()) || !method.getName().startsWith("get")) continue;
            return method;
        }
        return null;
    }

    private static <T> T getValueInternal(Class<T> returnType, ResultSet rs, Class<?> parameterType, Object[] parameter, T defaultValue) {
        Method method = ResultSetUtil.findMethod(returnType, parameterType);
        if (method == null) {
            return defaultValue;
        }
        try {
            Object result = method.invoke((Object)rs, parameter);
            return (T)result;
        }
        catch (IllegalArgumentException e) {
            throw new JiemamyError("The signature of the method must be verified.", e);
        }
        catch (IllegalAccessException e) {
            throw new JiemamyError("The method returned by getMethods() must be public.", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (!(e.getCause() instanceof SQLException)) {
                throw new JiemamyError("Checked exception which the invocation target thrown is not SQLException.", e.getCause());
            }
            return defaultValue;
        }
    }

    private ResultSetUtil() {
    }
}

