/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.seasar.framework.exception.ClassNotFoundRuntimeException;
import org.seasar.framework.exception.NoSuchFieldRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.MethodUtil;

public class SelectableDataSourceProxyUtil {
    private static Adapter adapter = SelectableDataSourceProxyUtil.getAdapter();

    private SelectableDataSourceProxyUtil() {
    }

    public static String getSelectableDataSourceName(DataSource dataSource) {
        return adapter.getDataSourceName(dataSource);
    }

    private static Adapter getAdapter() {
        try {
            ClassUtil.forName((String)"org.seasar.framework.env.Env");
        }
        catch (ClassNotFoundRuntimeException ignore) {
            return new AdapterS23();
        }
        return new AdapterS24();
    }

    private static class AdapterS24
    implements Adapter {
        private Class selectableDataSourceProxyClass = ClassUtil.forName((String)"org.seasar.extension.datasource.impl.SelectableDataSourceProxy");
        private Field dataSourceFactoryField;
        private Method getSelectableDataSourceNameMethod;

        private AdapterS24() {
            try {
                this.dataSourceFactoryField = this.selectableDataSourceProxyClass.getDeclaredField("dataSourceFactory");
            }
            catch (NoSuchFieldException ex) {
                throw new NoSuchFieldRuntimeException(this.selectableDataSourceProxyClass, "dataSourceFactory", ex);
            }
            this.dataSourceFactoryField.setAccessible(true);
            this.getSelectableDataSourceNameMethod = ClassUtil.getMethod(this.dataSourceFactoryField.getType(), (String)"getSelectableDataSourceName", null);
        }

        public String getDataSourceName(DataSource dataSource) {
            if (!this.selectableDataSourceProxyClass.isInstance(dataSource)) {
                return null;
            }
            Object dataSourceFactory = FieldUtil.get((Field)this.dataSourceFactoryField, (Object)dataSource);
            return (String)MethodUtil.invoke((Method)this.getSelectableDataSourceNameMethod, (Object)dataSourceFactory, null);
        }
    }

    private static class AdapterS23
    implements Adapter {
        private Class selectableDataSourceProxyClass = ClassUtil.forName((String)"org.seasar.extension.component.impl.SelectableDataSourceProxy");
        private Method getDataSourceNameMethod = ClassUtil.getMethod((Class)this.selectableDataSourceProxyClass, (String)"getDataSourceName", null);

        private AdapterS23() {
        }

        public String getDataSourceName(DataSource dataSource) {
            if (!this.selectableDataSourceProxyClass.isInstance(dataSource)) {
                return null;
            }
            return (String)MethodUtil.invoke((Method)this.getDataSourceNameMethod, (Object)dataSource, null);
        }
    }

    private static interface Adapter {
        public String getDataSourceName(DataSource var1);
    }
}

