/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.id;

import java.util.HashMap;
import javax.sql.DataSource;
import org.seasar.dao.Dbms;
import org.seasar.dao.id.AbstractIdentifierGenerator;
import org.seasar.dao.util.SelectableDataSourceProxyUtil;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.framework.util.LongConversionUtil;

public class SequenceIdentifierGenerator
extends AbstractIdentifierGenerator {
    private String sequenceName;
    private long allocationSize = 0L;
    private HashMap idContextMap = new HashMap();

    public SequenceIdentifierGenerator(PropertyType propertyType, Dbms dbms) {
        super(propertyType, dbms);
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public long getAllocationSize() {
        return this.allocationSize;
    }

    public void setAllocationSize(long allocationSize) {
        this.allocationSize = allocationSize;
    }

    public void setIdentifier(Object bean, DataSource ds) {
        this.setIdentifier(bean, this.getNextValue(ds));
    }

    public boolean isSelfGenerate() {
        return this.getDbms().isSelfGenerate();
    }

    protected Object getNextValue(DataSource ds) {
        if (this.allocationSize > 0L) {
            long value = this.getIdContext(ds).getNextValue(ds);
            return new Long(value);
        }
        return this.getNewInitialValue(ds);
    }

    protected Object getNewInitialValue(DataSource ds) {
        return this.executeSql(ds, this.getDbms().getSequenceNextValString(this.sequenceName), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IdContext getIdContext(DataSource ds) {
        HashMap hashMap = this.idContextMap;
        synchronized (hashMap) {
            String dsName = SelectableDataSourceProxyUtil.getSelectableDataSourceName(ds);
            IdContext context = (IdContext)this.idContextMap.get(dsName);
            if (context == null) {
                context = new IdContext();
                this.idContextMap.put(dsName, context);
            }
            return context;
        }
    }

    public class IdContext {
        protected long initialValue;
        protected long allocated = Long.MAX_VALUE;

        public synchronized long getNextValue(DataSource ds) {
            if (this.allocated < SequenceIdentifierGenerator.this.allocationSize) {
                return this.initialValue + this.allocated++;
            }
            this.initialValue = LongConversionUtil.toPrimitiveLong((Object)SequenceIdentifierGenerator.this.getNewInitialValue(ds));
            this.allocated = 1L;
            return this.initialValue;
        }
    }
}

