/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.NumericOperationEval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;

public class AddEval
extends NumericOperationEval {
    private AddPtg delegate;
    private static final ValueEvalToNumericXlator NUM_XLATOR = new ValueEvalToNumericXlator(219);

    public AddEval(Ptg ptg) {
        this.delegate = (AddPtg)ptg;
    }

    public ValueEvalToNumericXlator getXlator() {
        return NUM_XLATOR;
    }

    public Eval evaluate(Eval[] operands, int srcRow, short srcCol) {
        ErrorEval retval = null;
        double d = 0.0;
        switch (operands.length) {
            default: {
                retval = ErrorEval.UNKNOWN_ERROR;
                break;
            }
            case 2: {
                int iSize = 2;
                for (int i = 0; retval == null && i < iSize; ++i) {
                    ValueEval ve = this.singleOperandEvaluate(operands[i], srcRow, srcCol);
                    if (ve instanceof NumericValueEval) {
                        d += ((NumericValueEval)ve).getNumberValue();
                        continue;
                    }
                    if (ve instanceof BlankEval) continue;
                    retval = ErrorEval.VALUE_INVALID;
                }
            }
        }
        if (retval == null) {
            retval = Double.isNaN(d) ? ErrorEval.VALUE_INVALID : new NumberEval(d);
        }
        return retval;
    }

    public int getNumberOfOperands() {
        return this.delegate.getNumberOfOperands();
    }

    public int getType() {
        return this.delegate.getType();
    }
}

