/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.index.JmIndex;
import org.jiemamy.model.index.JmIndexColumn;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexValidator
extends AbstractValidator {
    public Collection<Problem> validate(JiemamyContext context) {
        ArrayList result = Lists.newArrayList();
        for (JmIndex index : context.getIndexes()) {
            ArrayList referenceColumnIds = Lists.newArrayList();
            if (index.getIndexColumns().size() < 1) {
                result.add(new NoIndexColumnProblem(index));
            }
            for (JmIndexColumn indexColumn : index.getIndexColumns()) {
                EntityRef<? extends JmColumn> columnRef = indexColumn.getColumnRef();
                if (referenceColumnIds.contains(columnRef.getReferentId())) {
                    JmColumn column = context.resolve(columnRef);
                    result.add(new DuplicatedIndexColumnsProblem(index, column));
                }
                referenceColumnIds.add(columnRef.getReferentId());
            }
        }
        return result;
    }

    static class NoIndexColumnProblem
    extends AbstractProblem {
        public NoIndexColumnProblem(JmIndex index) {
            super(index, "E0120", new Object[]{StringUtils.isEmpty((String)index.getName()) ? index.getId().toString() : index.getName()});
        }
    }

    static class DuplicatedIndexColumnsProblem
    extends AbstractProblem {
        protected DuplicatedIndexColumnsProblem(JmIndex index, JmColumn column) {
            super(index, "E0100", new Object[]{StringUtils.isEmpty((String)index.getName()) ? index.getId().toString() : index.getName(), column.getName()});
        }
    }
}

