/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.serializer.stax;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.xml.JiemamyNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StaxHandler<T> {
    private final StaxDirector director;

    public StaxHandler(StaxDirector director) {
        Validate.notNull((Object)director);
        this.director = director;
    }

    public abstract T handleDeserialization(DeserializationContext var1) throws SerializationException;

    public abstract void handleSerialization(T var1, SerializationContext var2) throws SerializationException;

    protected StaxDirector getDirector() {
        return this.director;
    }

    protected String getSchemaLocationDefinition(JiemamyNamespace[] namespaces) {
        StringBuilder sb = new StringBuilder();
        for (JiemamyNamespace namespace : namespaces) {
            String ns = namespace.getNamespaceURI().toString();
            String loc = namespace.getXmlSchemaLocation();
            if (StringUtils.isEmpty((String)ns) || StringUtils.isEmpty((String)loc)) continue;
            sb.append(" ").append(ns).append(" ").append(loc);
        }
        return sb.deleteCharAt(0).toString();
    }
}

