/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect;

import com.google.common.collect.Lists;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.dialect.DatabaseMetadataParser;
import org.jiemamy.dialect.ParseMetadataConfig;
import org.jiemamy.utils.sql.metadata.KeyMeta;
import org.jiemamy.utils.sql.metadata.TableMeta;
import org.jiemamy.utils.sql.metadata.TypeSafeDatabaseMetaData;
import org.jiemamy.utils.sql.metadata.TypeSafeResultSet;
import org.jiemamy.utils.visitor.AbstractTypeSafeResultSetVisitor;
import org.jiemamy.utils.visitor.ForEachUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatabaseReader {
    private final DatabaseMetadataParser parser;
    private final ParseMetadataConfig config;
    private final TypeSafeDatabaseMetaData metaData;

    public DatabaseReader(DatabaseMetadataParser parser, ParseMetadataConfig config, DatabaseMetaData meta) {
        Validate.notNull((Object)parser);
        Validate.notNull((Object)config);
        Validate.notNull((Object)meta);
        this.parser = parser;
        this.config = config;
        this.metaData = new TypeSafeDatabaseMetaData(meta);
    }

    public <T> T readEnities(ForEachUtil.TypeSafeResultSetVisitor<TableMeta, T, RuntimeException> visitor) throws SQLException {
        assert (this.parser != null);
        assert (this.config != null);
        assert (this.metaData != null);
        Validate.notNull(visitor);
        TypeSafeResultSet tables = this.metaData.getTables(null, this.config.getSchema(), "%", null);
        Object result = ForEachUtil.accept((TypeSafeResultSet)tables, visitor);
        return (T)result;
    }

    public <T> Collection<T> readRelations(ForEachUtil.TypeSafeResultSetVisitor<KeyMeta, T, RuntimeException> visitor) throws SQLException {
        assert (this.parser != null);
        assert (this.config != null);
        Validate.notNull(visitor);
        Collection entityNames = (Collection)this.readEnities((ForEachUtil.TypeSafeResultSetVisitor<TableMeta, T, RuntimeException>)new EntityNamesVisitor());
        ArrayList result = Lists.newArrayList();
        for (String entityName : entityNames) {
            TypeSafeResultSet importedKeys = this.metaData.getImportedKeys(null, this.config.getSchema(), entityName);
            result.add(ForEachUtil.accept((TypeSafeResultSet)importedKeys, visitor));
        }
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntityNamesVisitor
    extends AbstractTypeSafeResultSetVisitor<TableMeta, Collection<String>, RuntimeException> {
        private EntityNamesVisitor() {
        }

        public Collection<String> visit(TableMeta tableMeta) {
            ((Collection)this.finalResult).add(tableMeta.tableName);
            return null;
        }

        protected void init() {
            this.finalResult = Lists.newArrayList();
        }
    }
}

