/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.Validate;
import org.jiemamy.utils.JmStringUtil;
import org.jiemamy.utils.reflect.GenericUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    public static final String SET = "set";
    public static final String GET = "get";
    public static final String IS = "is";

    public static String convertAccessorToFieldName(Method method) {
        Validate.notNull((Object)method);
        if (!ReflectionUtil.isAccessor(method)) {
            throw new IllegalArgumentException();
        }
        Class<?> returnType = method.getReturnType();
        String name = method.getName();
        if ((returnType == Boolean.TYPE || returnType == Boolean.class) && name.startsWith(IS)) {
            return JmStringUtil.decapitalize(name.substring(2));
        }
        return JmStringUtil.decapitalize(name.substring(3));
    }

    public static String convertFieldNameToAccessorName(String fieldName, String prefix) {
        Validate.notNull((Object)fieldName);
        Validate.notNull((Object)prefix);
        return prefix + JmStringUtil.capitalize(fieldName);
    }

    public static String convertFieldNameToSetterName(String fieldName) {
        Validate.notNull((Object)fieldName);
        return ReflectionUtil.convertFieldNameToAccessorName(fieldName, SET);
    }

    public static String convertFieldToAccessorName(Field field, String prefix) {
        Validate.notNull((Object)field);
        Validate.notNull((Object)prefix);
        return ReflectionUtil.convertFieldNameToAccessorName(field.getName(), prefix);
    }

    public static String convertFieldToGetterName(Field field) {
        Validate.notNull((Object)field);
        if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
            return ReflectionUtil.convertFieldToAccessorName(field, IS);
        }
        return ReflectionUtil.convertFieldToAccessorName(field, GET);
    }

    public static String convertFieldToSetterName(Field field) {
        Validate.notNull((Object)field);
        return ReflectionUtil.convertFieldToAccessorName(field, SET);
    }

    public static <T> Class<T> forName(String className) throws ClassNotFoundException {
        return ReflectionUtil.forName(className, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Class<T> forName(String className, ClassLoader loader) throws ClassNotFoundException {
        return Class.forName(className, true, loader);
    }

    public static <T> Class<T> forNameNoException(String className) {
        return ReflectionUtil.forNameNoException(className, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Class<T> forNameNoException(String className, ClassLoader loader) {
        try {
            return Class.forName(className, true, loader);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public static Field getDeclaredFieldNoException(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Class<?> getElementTypeOfCollection(Type parameterizedCollection) {
        Validate.notNull((Object)parameterizedCollection);
        return GenericUtil.getRawClass(GenericUtil.getElementTypeOfCollection(parameterizedCollection));
    }

    public static Class<?> getElementTypeOfCollectionFromFieldType(Field field) {
        Validate.notNull((Object)field);
        Type type = field.getGenericType();
        return ReflectionUtil.getElementTypeOfCollection(type);
    }

    public static Class<?> getElementTypeOfCollectionFromParameterType(Method method, int parameterPosition) {
        Validate.notNull((Object)method);
        Type[] parameterTypes = method.getGenericParameterTypes();
        return ReflectionUtil.getElementTypeOfCollection(parameterTypes[parameterPosition]);
    }

    public static Class<?> getElementTypeOfCollectionFromReturnType(Method method) {
        Validate.notNull((Object)method);
        return ReflectionUtil.getElementTypeOfCollection(method.getGenericReturnType());
    }

    public static Class<?> getElementTypeOfList(Type parameterizedList) {
        Validate.notNull((Object)parameterizedList);
        return GenericUtil.getRawClass(GenericUtil.getElementTypeOfList(parameterizedList));
    }

    public static Class<?> getElementTypeOfListFromFieldType(Field field) {
        Validate.notNull((Object)field);
        Type type = field.getGenericType();
        return ReflectionUtil.getElementTypeOfList(type);
    }

    public static Class<?> getElementTypeOfListFromParameterType(Method method, int parameterPosition) {
        Validate.notNull((Object)method);
        Type[] parameterTypes = method.getGenericParameterTypes();
        return ReflectionUtil.getElementTypeOfList(parameterTypes[parameterPosition]);
    }

    public static Class<?> getElementTypeOfListFromReturnType(Method method) {
        Validate.notNull((Object)method);
        return ReflectionUtil.getElementTypeOfList(method.getGenericReturnType());
    }

    public static Class<?> getElementTypeOfSet(Type parameterizedSet) {
        Validate.notNull((Object)parameterizedSet);
        return GenericUtil.getRawClass(GenericUtil.getElementTypeOfSet(parameterizedSet));
    }

    public static Class<?> getElementTypeOfSetFromFieldType(Field field) {
        Validate.notNull((Object)field);
        Type type = field.getGenericType();
        return ReflectionUtil.getElementTypeOfSet(type);
    }

    public static Class<?> getElementTypeOfSetFromParameterType(Method method, int parameterPosition) {
        Validate.notNull((Object)method);
        Type[] parameterTypes = method.getGenericParameterTypes();
        return ReflectionUtil.getElementTypeOfSet(parameterTypes[parameterPosition]);
    }

    public static Class<?> getElementTypeOfSetFromReturnType(Method method) {
        Validate.notNull((Object)method);
        return ReflectionUtil.getElementTypeOfSet(method.getGenericReturnType());
    }

    public static boolean isAccessor(Method method) {
        return ReflectionUtil.isGetter(method) || ReflectionUtil.isSetter(method);
    }

    public static boolean isGetter(Method method) {
        Validate.notNull((Object)method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 0) {
            return false;
        }
        Class<?> returnType = method.getReturnType();
        String name = method.getName();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return false;
        }
        if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            boolean result;
            boolean bl = result = name.startsWith(IS) && name.length() > 2 && CharUtils.isAsciiAlphaUpper((char)name.toCharArray()[2]);
            if (result) {
                return true;
            }
        }
        return name.startsWith(GET) && name.length() > 3 && CharUtils.isAsciiAlphaUpper((char)name.toCharArray()[3]);
    }

    public static boolean isSetter(Method method) {
        Validate.notNull((Object)method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1) {
            return false;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE && returnType != Void.class) {
            return false;
        }
        String name = method.getName();
        return name.startsWith(SET) && name.length() > 3 && CharUtils.isAsciiAlphaUpper((char)name.toCharArray()[3]);
    }

    private ReflectionUtil() {
    }
}

