/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.reflect;

import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericUtil {
    public static Class<?> getActualClass(Type type, Map<TypeVariable<?>, Type> map) {
        Validate.notNull((Object)type);
        Validate.notNull(map);
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            return GenericUtil.getActualClass(((ParameterizedType)ParameterizedType.class.cast(type)).getRawType(), map);
        }
        if (WildcardType.class.isInstance(type)) {
            return GenericUtil.getActualClass(((WildcardType)WildcardType.class.cast(type)).getUpperBounds()[0], map);
        }
        if (TypeVariable.class.isInstance(type)) {
            return GenericUtil.getActualClass(map.get(TypeVariable.class.cast(type)), map);
        }
        if (GenericArrayType.class.isInstance(type)) {
            GenericArrayType genericArrayType = (GenericArrayType)GenericArrayType.class.cast(type);
            Class<?> componentClass = GenericUtil.getActualClass(genericArrayType.getGenericComponentType(), map);
            return Array.newInstance(componentClass, 0).getClass();
        }
        return null;
    }

    public static Class<?> getActualElementClassOfArray(Type type, Map<TypeVariable<?>, Type> map) {
        Validate.notNull((Object)type);
        Validate.notNull(map);
        if (!GenericArrayType.class.isInstance(type)) {
            return null;
        }
        return GenericUtil.getActualClass(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType(), map);
    }

    public static Class<?> getActualElementClassOfCollection(Type type, Map<TypeVariable<?>, Type> map) {
        Validate.notNull((Object)type);
        Validate.notNull(map);
        if (!GenericUtil.isTypeOf(type, Collection.class)) {
            return null;
        }
        return GenericUtil.getActualClass(GenericUtil.getGenericParameter(type, 0), map);
    }

    public static Class<?> getActualElementClassOfList(Type type, Map<TypeVariable<?>, Type> map) {
        Validate.notNull((Object)type);
        Validate.notNull(map);
        if (!GenericUtil.isTypeOf(type, List.class)) {
            return null;
        }
        return GenericUtil.getActualClass(GenericUtil.getGenericParameter(type, 0), map);
    }

    public static Class<?> getActualElementClassOfSet(Type type, Map<TypeVariable<?>, Type> map) {
        Validate.notNull((Object)type);
        Validate.notNull(map);
        if (!GenericUtil.isTypeOf(type, Set.class)) {
            return null;
        }
        return GenericUtil.getActualClass(GenericUtil.getGenericParameter(type, 0), map);
    }

    public static Class<?> getActualKeyClassOfMap(Type type, Map<TypeVariable<?>, Type> map) {
        Validate.notNull((Object)type);
        Validate.notNull(map);
        if (!GenericUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return GenericUtil.getActualClass(GenericUtil.getGenericParameter(type, 0), map);
    }

    public static Class<?> getActualValueClassOfMap(Type type, Map<TypeVariable<?>, Type> map) {
        Validate.notNull((Object)type);
        Validate.notNull(map);
        if (!GenericUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return GenericUtil.getActualClass(GenericUtil.getGenericParameter(type, 1), map);
    }

    public static Type getElementTypeOfArray(Type type) {
        Validate.notNull((Object)type);
        if (!GenericArrayType.class.isInstance(type)) {
            return null;
        }
        return ((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType();
    }

    public static Type getElementTypeOfCollection(Type type) {
        Validate.notNull((Object)type);
        if (!GenericUtil.isTypeOf(type, Collection.class)) {
            return null;
        }
        return GenericUtil.getGenericParameter(type, 0);
    }

    public static Type getElementTypeOfList(Type type) {
        Validate.notNull((Object)type);
        if (!GenericUtil.isTypeOf(type, List.class)) {
            return null;
        }
        return GenericUtil.getGenericParameter(type, 0);
    }

    public static Type getElementTypeOfSet(Type type) {
        Validate.notNull((Object)type);
        if (!GenericUtil.isTypeOf(type, Set.class)) {
            return null;
        }
        return GenericUtil.getGenericParameter(type, 0);
    }

    public static Type[] getGenericParameter(Type type) {
        Validate.notNull((Object)type);
        if (ParameterizedType.class.isInstance(type)) {
            return ((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments();
        }
        if (GenericArrayType.class.isInstance(type)) {
            return GenericUtil.getGenericParameter(((GenericArrayType)GenericArrayType.class.cast(type)).getGenericComponentType());
        }
        return new Type[0];
    }

    public static Type getGenericParameter(Type type, int index) {
        Validate.notNull((Object)type);
        if (!ParameterizedType.class.isInstance(type)) {
            return null;
        }
        Type[] genericParameter = GenericUtil.getGenericParameter(type);
        if (genericParameter == null) {
            return null;
        }
        return genericParameter[index];
    }

    public static Type getKeyTypeOfMap(Type type) {
        Validate.notNull((Object)type);
        if (!GenericUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return GenericUtil.getGenericParameter(type, 0);
    }

    public static Class<?> getRawClass(Type type) {
        Validate.notNull((Object)type);
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return GenericUtil.getRawClass(parameterizedType.getRawType());
        }
        if (WildcardType.class.isInstance(type)) {
            WildcardType wildcardType = (WildcardType)WildcardType.class.cast(type);
            Type[] types = wildcardType.getUpperBounds();
            return GenericUtil.getRawClass(types[0]);
        }
        if (GenericArrayType.class.isInstance(type)) {
            GenericArrayType genericArrayType = (GenericArrayType)GenericArrayType.class.cast(type);
            Class<?> rawClass = GenericUtil.getRawClass(genericArrayType.getGenericComponentType());
            return Array.newInstance(rawClass, 0).getClass();
        }
        return null;
    }

    public static Map<TypeVariable<?>, Type> getTypeVariableMap(Class<?> clazz) {
        Validate.notNull(clazz);
        LinkedHashMap map = Maps.newLinkedHashMap();
        Class<?> superClass = clazz.getSuperclass();
        Type superClassType = clazz.getGenericSuperclass();
        if (superClass != null) {
            GenericUtil.gatherTypeVariables(superClass, superClassType, map);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Type[] interfaceTypes = clazz.getGenericInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            GenericUtil.gatherTypeVariables(interfaces[i], interfaceTypes[i], map);
        }
        return map;
    }

    public static Type getValueTypeOfMap(Type type) {
        Validate.notNull((Object)type);
        if (!GenericUtil.isTypeOf(type, Map.class)) {
            return null;
        }
        return GenericUtil.getGenericParameter(type, 1);
    }

    public static boolean isTypeOf(Type type, Class<?> clazz) {
        Validate.notNull(clazz);
        if (Class.class.isInstance(type)) {
            return clazz.isAssignableFrom((Class)Class.class.cast(type));
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            return GenericUtil.isTypeOf(parameterizedType.getRawType(), clazz);
        }
        return false;
    }

    protected static void gatherTypeVariables(Class<?> clazz, Type type, Map<TypeVariable<?>, Type> map) {
        if (clazz == null) {
            return;
        }
        GenericUtil.gatherTypeVariables(type, map);
        Class<?> superClass = clazz.getSuperclass();
        Type superClassType = clazz.getGenericSuperclass();
        if (superClass != null) {
            GenericUtil.gatherTypeVariables(superClass, superClassType, map);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Type[] interfaceTypes = clazz.getGenericInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            GenericUtil.gatherTypeVariables(interfaces[i], interfaceTypes[i], map);
        }
    }

    protected static void gatherTypeVariables(Type type, Map<TypeVariable<?>, Type> map) {
        Validate.notNull((Object)type);
        Validate.notNull(map);
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(type);
            TypeVariable<?>[] typeVariables = ((GenericDeclaration)GenericDeclaration.class.cast(parameterizedType.getRawType())).getTypeParameters();
            Type[] actualTypes = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < actualTypes.length; ++i) {
                map.put(typeVariables[i], actualTypes[i]);
            }
        }
    }

    private GenericUtil() {
    }
}

