/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.Validate;
import org.jiemamy.utils.reflect.MethodUtil;
import org.jiemamy.utils.reflect.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FieldUtil.class);
    private static final Method GET_ELEMENT_TYPE_OF_COLLECTION_FROM_FIELD_TYPE_METHOD = FieldUtil.getElementTypeFromFieldTypeMethod("Collection");
    private static final Method GET_ELEMENT_TYPE_OF_LIST_FROM_FIELD_TYPE_METHOD = FieldUtil.getElementTypeFromFieldTypeMethod("List");
    private static final Method GET_ELEMENT_TYPE_OF_SET_FROM_FIELD_TYPE_METHOD = FieldUtil.getElementTypeFromFieldTypeMethod("Set");

    public static Class<?> getElementTypeOfCollectionFromFieldType(Field field) {
        Validate.notNull((Object)field);
        try {
            return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_COLLECTION_FROM_FIELD_TYPE_METHOD, null, new Object[]{field});
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Class<?> getElementTypeOfListFromFieldType(Field field) {
        Validate.notNull((Object)field);
        try {
            return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_LIST_FROM_FIELD_TYPE_METHOD, null, new Object[]{field});
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Class<?> getElementTypeOfSetFromFieldType(Field field) {
        Validate.notNull((Object)field);
        try {
            return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_SET_FROM_FIELD_TYPE_METHOD, null, new Object[]{field});
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static <T> T getValue(Class<T> type, Field field, Object target) throws IllegalArgumentException, IllegalAccessException {
        Validate.notNull(type);
        Validate.notNull((Object)field);
        Validate.notNull((Object)target);
        return type.cast(field.get(target));
    }

    public static boolean isInstanceField(Field field) {
        Validate.notNull((Object)field);
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    protected static Method getElementTypeFromFieldTypeMethod(String type) {
        Validate.notNull((Object)type);
        try {
            return ReflectionUtil.class.getMethod("getElementTypeOf" + type + "FromFieldType", Field.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private FieldUtil() {
    }
}

