/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.dbms;

import org.seasar.codegen.LanguageDataTypeSelectHelper;
import org.seasar.codegen.dbms.Dbms;
import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.FieldSetting;
import org.seasar.codegen.exception.InternalGenerateException;

public class DB2
implements Dbms {
    private LanguageDataTypeSelectHelper langSelectUtil;

    public String convDBTypeToDataType(String typeName) {
        return typeName;
    }

    public DataType selectBestDataType(FieldSetting fieldSetting) throws InternalGenerateException {
        String typeName = fieldSetting.getTypeName();
        fieldSetting.setRdbType(fieldSetting.getTypeName());
        DataType dataType = null;
        if (typeName.startsWith("BIGINT")) {
            dataType = this.getAnyDataType(fieldSetting, "long");
        } else if (typeName.startsWith("BLOB")) {
            dataType = this.getAnyDataType(fieldSetting, "byte[]");
        } else if (typeName.startsWith("CHAR")) {
            dataType = this.getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("CLOB")) {
            dataType = this.getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("DOUBLE")) {
            dataType = this.getAnyDataType(fieldSetting, "BigDecimal");
        } else if (typeName.startsWith("DOUBLE PRECISION")) {
            dataType = this.getAnyDataType(fieldSetting, "BigDecimal");
        } else if (typeName.startsWith("FLOAT")) {
            dataType = this.getAnyDataType(fieldSetting, "BigDecimal");
        } else if (typeName.startsWith("INTEGER")) {
            dataType = this.getAnyDataType(fieldSetting, "int");
        } else if (typeName.startsWith("LONG VARCHAR")) {
            dataType = this.getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("REAL")) {
            dataType = this.getAnyDataType(fieldSetting, "BigDecimal");
        } else if (typeName.startsWith("SMALLINT")) {
            dataType = this.getAnyDataType(fieldSetting, "short");
        } else if (typeName.startsWith("VARCHAR")) {
            dataType = this.getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("TIMESTAMP")) {
            dataType = this.getAnyDataType(fieldSetting, "Timestamp");
        } else if (typeName.startsWith("TIME")) {
            dataType = this.getAnyDataType(fieldSetting, "Time");
        } else if (typeName.startsWith("DATE")) {
            dataType = this.getAnyDataType(fieldSetting, "Date");
        } else if (typeName.startsWith("DECIMAL")) {
            dataType = this.getDECIMAL(fieldSetting);
        } else if (typeName.startsWith("NUMERIC")) {
            dataType = this.getDECIMAL(fieldSetting);
        } else {
            throw new InternalGenerateException(fieldSetting.getTypeName());
        }
        return dataType;
    }

    protected DataType getDECIMAL(FieldSetting fieldSetting) {
        String dataType = null;
        dataType = fieldSetting.getPointNumber() == 0 ? (fieldSetting.getColmnSize() == 1 ? "boolean" : (fieldSetting.getColmnSize() <= 9 ? "int" : (fieldSetting.getColmnSize() <= 18 ? "long" : "BigInteger"))) : "BigDecimal";
        return this.getAnyDataType(fieldSetting, dataType);
    }

    protected DataType getAnyDataType(FieldSetting fieldSetting, String javaDataType) {
        DataType dataType = new DataType(fieldSetting);
        dataType.setLangDataType(this.langSelectUtil.getDataType(javaDataType, fieldSetting.isNotNull(), fieldSetting.getFieldDefault()));
        return dataType;
    }

    public LanguageDataTypeSelectHelper getLangSelectUtil() {
        return this.langSelectUtil;
    }

    public void setLangSelectUtil(LanguageDataTypeSelectHelper langSelectUtil) {
        this.langSelectUtil = langSelectUtil;
    }

    public String getSuffix() {
        return "db2";
    }
}

