/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.element;

import org.seasar.codegen.util.ToStringUtil;

public class DataType {
    private String rdbTypeName;

    private boolean isNotNull;

    private int colmnSize;

    private int pointNumber;

    private String defaultVal;

    private LangDataType langDataType;

    public DataType(FieldSetting fieldSetting) {
        this.rdbTypeName = fieldSetting.getRdbType();
        this.colmnSize = fieldSetting.getColmnSize();
        this.pointNumber = fieldSetting.getPointNumber();
        this.isNotNull = fieldSetting.isNotNull();
        this.defaultVal = fieldSetting.getFieldDefault();
    }

    public int getColmnSize() {
        return colmnSize;
    }

    public int getPointNumber() {
        return pointNumber;
    }

    public String getRdbTypeName() {
        return rdbTypeName;
    }

    public void setColmnSize(int colmnSize) {
        this.colmnSize = colmnSize;
    }

    public void setPointNumber(int pointNumber) {
        this.pointNumber = pointNumber;
    }

    public boolean isNotNull() {
        return isNotNull;
    }

    public String getIsNotNullString() {
        return isNotNull() ? "NOT NULL" : "";
    }

    public String getDefaultVal() {
        return defaultVal;
    }

    public LangDataType getLangDataType() {
        return langDataType;
    }

    public void setLangDataType(LangDataType langDataType) {
        this.langDataType = langDataType;
    }

    public String toString() {
        return ToStringUtil.toString(this);
    }
}
