/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/**
 * 
 */
package org.seasar.codegen.impl;

import java.io.File;
import java.net.URL;
import java.util.Map;

import org.seasar.codegen.DDL;
import org.seasar.codegen.dbms.Dbms;
import org.seasar.codegen.element.Table;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ResourceUtil;

/**
 * @author azusa
 * 
 */
@DDL
public class DDLOutputCodeImpl extends NormalDiconOutputCodeImpl {

    private Logger log = Logger.getLogger(DDLOutputCodeImpl.class);

    protected Dbms dbms;

    @Override
    public void generateCode(File baseDir, Map<String, Table> tableList) {
        if (!codegenConfig.isOutputDDL()) {
            return;
        }
        String templateFileName = getTemplateFileName() + "_"
                + dbms.getSuffix() + ".ftl";
        URL url = ResourceUtil
                .getResourceNoException("/org/seasar/codegen/templates/"
                        + templateFileName);
        if (url == null) {
            log.log("WCDG0003", new String[] { templateFileName });
            return;
        }
        super.setTemplateFileName(templateFileName);
        super.generateCode(baseDir, tableList);
    }

    @Binding(bindingType = BindingType.MAY)
    public void setDbms(Dbms dbms) {
        this.dbms = dbms;
    }
}
