/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/**
 * 
 */
package org.seasar.codegen.convert.impl;

import org.seasar.dao.pager.DefaultPagerCondition;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.StringUtil;

/**
 * @author azusa
 * 
 */
public class CamelConverterImpl extends AbstractConverter {

    public String convertFieldName(String fieldName) {
        if (StringUtil.isEmpty(fieldName)) {
            return fieldName;
        }
        String[] split = fieldName.split("_");

        StringBuffer buf = new StringBuffer();
        buf.append(split[0].toLowerCase());
        for (int i = 1; i < split.length; i++) {
            buf.append(split[i].substring(0, 1).toUpperCase());
            if (split[i].length() > 1) {
                buf.append(split[i].substring(1).toLowerCase());
            }
        }
        String result = buf.toString();
        return escapeDuplicateProperty(result);
    }

    protected String escapeDuplicateProperty(String result) {
        BeanDesc beanDesc = BeanDescFactory
                .getBeanDesc(DefaultPagerCondition.class);
        if (beanDesc.hasPropertyDesc(result)) {
            return "entity_" + result;
        } else {
            return result;
        }

    }

    public String convertClassName(String className) {
        if (StringUtil.isEmpty(className)) {
            return className;
        }
        String[] split = className.split("_");

        StringBuffer buf = new StringBuffer();
        buf.append(split[0].substring(0, 1).toUpperCase());
        buf.append(split[0].substring(1).toLowerCase());
        for (int i = 1; i < split.length; i++) {
            buf.append(split[i].substring(0, 1).toUpperCase());
            if (split[i].length() > 1) {
                buf.append(split[i].substring(1).toLowerCase());
            }
        }
        return buf.toString();

    }

}
