/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.util;

import org.seasar.codegen.element.PrimaryKey;
import org.seasar.framework.util.StringUtil;

/**
 * 主キーのモデルにCodeGenConfigで設定されたシーケンス情報を設定するためのユーティリティクラス
 * 
 * @author azusa
 * 
 */
public class SequnceUtil {

    /**
     * 主キーのモデルにシーケンス情報を設定します。
     * 
     * @param primaryKey
     *            主キー
     * @param sequenceName
     *            シーケンス名。設定しない場合は{@code null}
     */
    public static void addSequence(PrimaryKey primaryKey, String sequenceName) {
        if (!StringUtil.isEmpty(sequenceName)) {
            primaryKey.getField().setSequence(sequenceName);
        }
    }
}
