/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.impl;

import java.util.Map;

import org.seasar.codegen.CodeGenConfig;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;

public class CodeGenConfigImpl implements CodeGenConfig {

    private String headerTemplatePath;

    private String versionNoPropertyName;

    private String timestampPropertyName;

    private String identityType;

    private String inputFile;

    private String packageName;

    private String encoding = "UTF-8";

    @Binding(bindingType = BindingType.MAY)
    private Map<String, String> sequnceMapping;

    @Binding(bindingType = BindingType.MUST)
    private boolean outputAllDaoDicon;

    @Binding(bindingType = BindingType.MUST)
    private boolean outputDDL;

    public String getHeaderTemplatePath() {
        return headerTemplatePath;
    }

    public void setHeaderTemplatePath(String headerTemplatePath) {
        this.headerTemplatePath = headerTemplatePath;
    }

    public String getVersionNoPropertyName() {
        return versionNoPropertyName;
    }

    public void setVersionNoPropertyName(String versionNoPropertyName) {
        this.versionNoPropertyName = versionNoPropertyName;
    }

    public String getTimestampPropertyName() {
        return this.timestampPropertyName;
    }

    public boolean isTimestamp() {
        return this.timestampPropertyName != null;
    }

    public boolean isVersionNo() {
        return versionNoPropertyName != null;
    }

    public void setTimestampPropertyName(String timestampPropertyName) {
        this.timestampPropertyName = timestampPropertyName;
    }

    public String getIdentityType() {
        return identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public boolean isOutputAllDaoDicon() {
        return outputAllDaoDicon;
    }

    public void setOutputAllDaoDicon(boolean outputResource) {
        this.outputAllDaoDicon = outputResource;
    }

    public boolean isOutputDDL() {
        return outputDDL;
    }

    public void setOutputDDL(boolean outputDDL) {
        this.outputDDL = outputDDL;
    }

    public String getInputFile() {
        return inputFile;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getEncoding() {
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Map<String, String> getSequnceMapping() {
        return sequnceMapping;
    }

    public void setSequnceMapping(Map<String, String> sequnceMapping) {
        this.sequnceMapping = sequnceMapping;
    }

}
