/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.dbms;

import java.util.HashMap;
import java.util.Map;
import org.seasar.codegen.LanguageDataTypeSelectHelper;
import org.seasar.codegen.dbms.Dbms;
import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.FieldSetting;
import org.seasar.codegen.exception.NotTypeMatchException;

public class MaxDB
implements Dbms {
    final String stringTypeName = "string";
    final String numberTypeName = "num";
    final String dateTypeName = "date";
    final String timeTypeName = "time";
    final String timestampTypeName = "timestamp";
    final String booleanTypeName = "bool";
    final String blobTypeName = "blob";
    private LanguageDataTypeSelectHelper langSelectUtil;
    private Map<String, String> typeToType = new HashMap<String, String>();

    public MaxDB() {
        this.typeToType.put("BIGINT", "num");
        this.typeToType.put("INTEGER", "num");
        this.typeToType.put("VARCHAR", "string");
        this.typeToType.put("LONG", "string");
        this.typeToType.put("DATE", "date");
        this.typeToType.put("NUMBER", "num");
        this.typeToType.put("SMALLINT", "num");
    }

    public String convDBTypeToDataType(String typeName) {
        return this.typeToType.get(typeName);
    }

    public DataType selectBestDataType(FieldSetting fieldSetting) {
        String lowTypeName = fieldSetting.getTypeName().toLowerCase();
        DataType dataType = null;
        if (lowTypeName.startsWith("string")) {
            dataType = this.getStringDataType(fieldSetting);
        } else if (lowTypeName.startsWith("num")) {
            dataType = this.getNumberTypeName(fieldSetting);
        } else if (lowTypeName.startsWith("date")) {
            dataType = this.getTimestampTypeName(fieldSetting);
        } else if (lowTypeName.startsWith("time")) {
            dataType = this.getTimestampTypeName(fieldSetting);
        } else if (lowTypeName.startsWith("timestamp")) {
            dataType = this.getTimestampTypeName(fieldSetting);
        } else if (lowTypeName.startsWith("bool")) {
            dataType = this.getBooleanTypeName(fieldSetting);
        } else {
            throw new NotTypeMatchException(fieldSetting.getTypeName());
        }
        return dataType;
    }

    protected DataType getStringDataType(FieldSetting fieldSetting) {
        fieldSetting.setRdbType("VARCHAR");
        DataType dataType = new DataType(fieldSetting);
        dataType.setLangDataType(this.langSelectUtil.getDataType("String", fieldSetting.isNotNull(), fieldSetting.getFieldDefault()));
        return dataType;
    }

    protected DataType getNumberTypeName(FieldSetting fieldSetting) {
        if (fieldSetting.getPointNumber() > 0) {
            return this.getDoubleTypeName(fieldSetting);
        }
        if (fieldSetting.getColmnSize() == 2) {
            return this.getBooleanTypeName(fieldSetting);
        }
        return this.getLongTypeName(fieldSetting);
    }

    protected DataType getDoubleTypeName(FieldSetting fieldSetting) {
        fieldSetting.setRdbType("NUMBER");
        if (fieldSetting.isNotNull()) {
            fieldSetting.setRdbType("NUMBER");
        }
        DataType dataType = new DataType(fieldSetting);
        dataType.setLangDataType(this.langSelectUtil.getDataType("Double", fieldSetting.isNotNull(), fieldSetting.getFieldDefault()));
        return dataType;
    }

    protected DataType getLongTypeName(FieldSetting fieldSetting) {
        fieldSetting.setRdbType("INTEGER");
        if (fieldSetting.isNotNull()) {
            fieldSetting.setRdbType("INTEGER");
        }
        DataType dataType = new DataType(fieldSetting);
        dataType.setLangDataType(this.langSelectUtil.getDataType("Long", fieldSetting.isNotNull(), fieldSetting.getFieldDefault()));
        return dataType;
    }

    protected DataType getTimestampTypeName(FieldSetting fieldSetting) {
        fieldSetting.setRdbType("DATE");
        DataType dataType = new DataType(fieldSetting);
        dataType.setLangDataType(this.langSelectUtil.getDataType("Date", fieldSetting.isNotNull(), fieldSetting.getFieldDefault()));
        return dataType;
    }

    protected DataType getBooleanTypeName(FieldSetting fieldSetting) {
        fieldSetting.setRdbType("NUMBER");
        fieldSetting.setColmnSize(2);
        if (fieldSetting.isNotNull()) {
            fieldSetting.setRdbType("NUMBER");
        }
        DataType dataType = new DataType(fieldSetting);
        dataType.setLangDataType(this.langSelectUtil.getDataType("Boolean", fieldSetting.isNotNull(), fieldSetting.getFieldDefault()));
        return dataType;
    }

    public LanguageDataTypeSelectHelper getLangSelectUtil() {
        return this.langSelectUtil;
    }

    public void setLangSelectUtil(LanguageDataTypeSelectHelper langSelectUtil) {
        this.langSelectUtil = langSelectUtil;
    }

    public String getSuffix() {
        return "maxdb";
    }
}

