/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/**
 * 
 */
package org.seasar.codegen;

import java.util.Map;

/**
 * CodeGenの設定オプションの保持クラスのインターフェースです。
 * 
 * @author azusa
 * 
 */
public interface CodeGenConfig {

    /**
     * ヘッダーのテンプレートファイルのパスを返します。
     * 
     * @return ヘッダーのテンプレートファイル
     */
    public String getHeaderTemplatePath();

    /**
     * バージョン番号による排他制御用のプロパティ名を返します。
     * 
     * @return バージョン番号による排他制御用のプロパティ名
     */
    public String getVersionNoPropertyName();

    /**
     * タイムスタンプによる排他制御用のプロパティ名を返します。
     * 
     * @return タイムスタンプによる排他制御用
     */
    public String getTimestampPropertyName();

    /**
     * バージョン番号による排他制御を行うかを返します。
     * 
     * @return バージョン番号による排他制御を行う場合<code>true</code>
     */
    public boolean isVersionNo();

    /**
     * タイムスタンプによる排他制御を行うかを返します。
     * 
     * @return タイムスタンプによる排他制御を行う場合<code>true</code>
     */
    public boolean isTimestamp();

    /**
     * 主キーの自動生成方法の指定を返します。
     * 
     * @return 主キーの自動生成方法
     */
    public String getIdentityType();

    /**
     * alldao.diconを出力するかを返します。
     * 
     * @return 出力する場合<code>true</code>
     */
    public boolean isOutputAllDaoDicon();

    /**
     * DDLを出力するかを返します。
     * 
     * @return 出力する場合<code>true</code>
     */
    public boolean isOutputDDL();

    /**
     * エンティティの詳細を記述したファイルのパスを返します。
     * 
     * @return エンティティの詳細を記述したファイル
     */
    public String getInputFile();

    /**
     * 出力するJavaソースのルートパッケージを返します。
     * 
     * @return 出力するJavaソースのルートパッケージ。
     */
    public String getPackageName();

    /**
     * 出力するリソースのエンコーディングを返します。 デフォルトは&quot;UTF-8&quot;です。
     * 
     * @return 出力するリソースのエンコーディング
     */
    public String getEncoding();

    /**
     * 主キーのカラムと自動採番に使用するシーケンスのマッピングを返します。
     * 
     * @return
     */
    public Map<String, String> getSequnceMapping();
}
