/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.dbms;

import org.seasar.codegen.dbms.AbstractDbms;
import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.FieldSetting;
import org.seasar.codegen.exception.NotTypeMatchException;

public class Oracle
extends AbstractDbms {
    public String convDBTypeToDataType(String typeName) {
        return typeName;
    }

    public DataType selectBestDataType(FieldSetting fieldSetting) {
        String typeName = fieldSetting.getTypeName();
        fieldSetting.setRdbType(fieldSetting.getTypeName());
        DataType dataType = null;
        if (typeName.startsWith("INTEGER")) {
            dataType = this.getAnyDataType(fieldSetting, "long");
        } else if (typeName.startsWith("BINARY_FLOAT")) {
            dataType = this.getAnyDataType(fieldSetting, "BigDecimal");
        } else if (typeName.startsWith("BINARY_DOUBLE")) {
            dataType = this.getAnyDataType(fieldSetting, "BigDecimal");
        } else if (typeName.startsWith("RAW")) {
            dataType = this.getAnyDataType(fieldSetting, "byte[]");
        } else if (typeName.startsWith("BLOB")) {
            dataType = this.getAnyDataType(fieldSetting, "byte[]");
        } else if (typeName.startsWith("CHAR")) {
            dataType = this.getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("LONG")) {
            dataType = this.getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("CLOB")) {
            dataType = this.getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("VARCHAR2")) {
            dataType = this.getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("VARCHAR")) {
            dataType = this.getAnyDataType(fieldSetting, "String");
        } else if (typeName.startsWith("DATE")) {
            dataType = this.getAnyDataType(fieldSetting, "Date");
        } else if (typeName.startsWith("TIMESTAMP")) {
            dataType = this.getAnyDataType(fieldSetting, "Timestamp");
        } else if (typeName.startsWith("TIME")) {
            dataType = this.getAnyDataType(fieldSetting, "Time");
        } else if (typeName.startsWith("DECIMAL")) {
            dataType = this.getDECIMAL(fieldSetting);
        } else if (typeName.startsWith("NUMERIC")) {
            dataType = this.getDECIMAL(fieldSetting);
        } else if (typeName.startsWith("NUMBER")) {
            dataType = this.getDECIMAL(fieldSetting);
        } else {
            throw new NotTypeMatchException(fieldSetting.getTypeName());
        }
        return dataType;
    }

    public String getSuffix() {
        return "oracle";
    }
}

