/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.PrimaryKey;
import org.seasar.codegen.element.Table;
import org.seasar.codegen.impl.ExcelImportCodeDataSupport;
import org.seasar.codegen.util.ExcelUtil;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelImportCodeDataMultiSheet
extends ExcelImportCodeDataSupport {
    protected int entityNameRow = 0;
    protected int entityNameCol = 1;
    protected int tableNameRow = 1;
    protected int tableNameCol = 1;
    protected int columnStartRow = 4;

    public ExcelImportCodeDataMultiSheet() {
        this.attributeNameCol = 0;
        this.columnNameCol = 1;
        this.dataTypeCol = 2;
        this.notNullCol = 3;
        this.primaryKeyCol = 4;
        this.foreignKeyCol = 5;
        this.defaultValueCol = 6;
        this.relationTypeCol = 7;
        this.parentTableCol = 8;
        this.parentColumnCol = 9;
        this.cardinalityCol = 10;
        this.parentPropertyCol = 11;
        this.childPropertyCol = 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Table> readCodeData(File srcFile) {
        InputStream in = FileInputStreamUtil.create((File)srcFile);
        try {
            Map<String, Table> tableMap;
            in = new BufferedInputStream(in);
            HSSFWorkbook book = ExcelUtil.createWorkbook(in);
            Map<String, Table> map = tableMap = this.readCodeData(book);
            return map;
        }
        finally {
            InputStreamUtil.close((InputStream)in);
        }
    }

    protected Map<String, Table> readCodeData(HSSFWorkbook book) {
        LinkedHashMap<String, Table> tableMap = new LinkedHashMap<String, Table>();
        for (int i = 0; i < book.getNumberOfSheets(); ++i) {
            HSSFSheet sheet = book.getSheetAt(i);
            Table table = this.getTable(sheet);
            if (table == null) continue;
            tableMap.put(table.getTableName(), table);
        }
        this.setupChildLinks(tableMap);
        return tableMap;
    }

    protected Table getTable(HSSFSheet sheet) {
        String tableName = this.getString(sheet, this.tableNameRow, this.tableNameCol);
        if (StringUtil.isEmpty((String)tableName)) {
            return null;
        }
        Table table = new Table();
        table.setTableName(tableName);
        for (int i = this.columnStartRow; i <= sheet.getLastRowNum(); ++i) {
            LinkTable parentLink;
            HSSFRow row = sheet.getRow(i);
            Field field = this.getField(row);
            if (field == null) continue;
            table.addTableField(field);
            PrimaryKey primaryKey = this.getPrimaryKey(row, field);
            if (primaryKey != null) {
                table.addPrimaryKey(primaryKey);
            }
            if ((parentLink = this.getParentLink(row, field)) == null) continue;
            String relName = this.converter.convertParent(table, parentLink);
            table.addLinkTable(relName, parentLink);
        }
        return table;
    }
}

