/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.element;

import java.util.List;

import org.seasar.codegen.util.ToStringUtil;

public class Field {
    private String fieldName;

    private String fieldAttributeName;

    private DataType dataType;

    private List<FieldValidator> validator;

    private String defaultVal;

    private String sequence;

    private String outputFormat;

    private String fieldNameForDto;

    private boolean useIdentity;

    public DataType getDataType() {
        return dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public String getDefaultVal() {
        return defaultVal;
    }

    public void setDefaultVal(String defaultVal) {
        this.defaultVal = defaultVal;
    }

    public String getOutputFormat() {
        return outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getSequence() {
        return sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public List<FieldValidator> getValidator() {
        return validator;
    }

    public void setValidator(List<FieldValidator> validator) {
        this.validator = validator;
    }

    public void addFieldValidator(FieldValidator fieldValidator) {
        validator.add(fieldValidator);
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldNameForDto() {
        if (fieldNameForDto == null) {
            return fieldName;
        }
        return fieldNameForDto;
    }

    public void setFieldNameForDto(String fieldNameForDto) {
        this.fieldNameForDto = fieldNameForDto;
    }

    public String getFieldAttributeName() {
        return fieldAttributeName;
    }

    public void setFieldAttributeName(String fieldCommentName) {
        this.fieldAttributeName = fieldCommentName;
    }

    public boolean isUseSequence() {
        return sequence != null;
    }

    public boolean isUseIdentity() {
        return useIdentity;
    }

    public void setUseIdentity(boolean useIdentity) {
        this.useIdentity = useIdentity;
    }

    public String toString() {
        return ToStringUtil.toString(this);
    }

}
